/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.core.StatementVariableRef;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.util.ManagedReadWriteLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementVariableRefImpl
implements StatementVariableRef {
    private static final Log log = LogFactory.getLog(StatementVariableRefImpl.class);
    private final ManagedReadWriteLock mapLock;
    private final HashMap<String, Set<String>> variableToStmt = new HashMap();
    private final HashMap<String, Set<String>> stmtToVariable = new HashMap();
    private final VariableService variableService;
    private final Set<String> configuredVariables;

    public StatementVariableRefImpl(VariableService variableService) {
        this.mapLock = new ManagedReadWriteLock("StatementVariableRefImpl", false);
        this.variableService = variableService;
        this.configuredVariables = new HashSet<String>();
        for (Map.Entry<String, VariableReader> entry : variableService.getVariables().entrySet()) {
            this.configuredVariables.add(entry.getKey());
        }
    }

    @Override
    public void addConfiguredVariable(String variableName) {
        this.configuredVariables.add(variableName);
    }

    @Override
    public void removeConfiguredVariable(String variableName) {
        this.configuredVariables.remove(variableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReferences(String statementName, Set<String> variablesReferenced) {
        if (variablesReferenced == null || variablesReferenced.isEmpty()) {
            return;
        }
        this.mapLock.acquireWriteLock();
        try {
            for (String ref : variablesReferenced) {
                this.addReference(statementName, ref);
            }
        }
        finally {
            this.mapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReferencesStatement(String statementName) {
        this.mapLock.acquireWriteLock();
        try {
            Set<String> variables = this.stmtToVariable.remove(statementName);
            if (variables != null) {
                for (String variable : variables) {
                    this.removeReference(statementName, variable);
                }
            }
        }
        finally {
            this.mapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReferencesVariable(String name) {
        this.mapLock.acquireWriteLock();
        try {
            Set<String> statementNames = this.variableToStmt.remove(name);
            if (statementNames != null) {
                for (String statementName : statementNames) {
                    this.removeReference(statementName, name);
                }
            }
        }
        finally {
            this.mapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInUse(String variable) {
        this.mapLock.acquireReadLock();
        try {
            boolean bl = this.variableToStmt.containsKey(variable);
            return bl;
        }
        finally {
            this.mapLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getStatementNamesForVar(String variableName) {
        this.mapLock.acquireReadLock();
        try {
            Set<String> variables = this.variableToStmt.get(variableName);
            if (variables == null) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            Set<String> set = Collections.unmodifiableSet(variables);
            return set;
        }
        finally {
            this.mapLock.releaseReadLock();
        }
    }

    private void addReference(String statementName, String variableName) {
        Set<String> statements = this.variableToStmt.get(variableName);
        if (statements == null) {
            statements = new HashSet<String>();
            this.variableToStmt.put(variableName, statements);
        }
        statements.add(statementName);
        Set<String> variables = this.stmtToVariable.get(statementName);
        if (variables == null) {
            variables = new HashSet<String>();
            this.stmtToVariable.put(statementName, variables);
        }
        variables.add(variableName);
    }

    private void removeReference(String statementName, String variableName) {
        Set<String> variables;
        Set<String> statements = this.variableToStmt.get(variableName);
        if (statements != null) {
            if (!statements.remove(statementName)) {
                log.info("Failed to find statement name '" + statementName + "' in collection");
            }
            if (statements.isEmpty()) {
                this.variableToStmt.remove(variableName);
                if (!this.configuredVariables.contains(variableName)) {
                    this.variableService.removeVariable(variableName);
                }
            }
        }
        if ((variables = this.stmtToVariable.get(statementName)) != null) {
            if (!variables.remove(variableName)) {
                log.info("Failed to find variable '" + variableName + "' in collection");
            }
            if (variables.isEmpty()) {
                this.stmtToVariable.remove(statementName);
            }
        }
    }

    protected HashMap<String, Set<String>> getVariableToStmt() {
        return this.variableToStmt;
    }

    protected HashMap<String, Set<String>> getStmtToVariable() {
        return this.stmtToVariable;
    }
}

