/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.core.UpdateDispatchFutureSpin;
import com.espertech.esper.core.UpdateDispatchViewBase;
import com.espertech.esper.dispatch.DispatchService;
import com.espertech.esper.timer.TimeSourceService;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDispatchViewBlockingSpin
extends UpdateDispatchViewBase {
    private UpdateDispatchFutureSpin currentFutureSpin;
    private long msecTimeout;
    private TimeSourceService timeSourceService;
    private static Log log = LogFactory.getLog(UpdateDispatchViewBlockingSpin.class);

    public UpdateDispatchViewBlockingSpin(StatementResultService statementResultService, DispatchService dispatchService, long msecTimeout, TimeSourceService timeSourceService) {
        super(statementResultService, dispatchService);
        this.currentFutureSpin = new UpdateDispatchFutureSpin(timeSourceService);
        this.msecTimeout = msecTimeout;
        this.timeSourceService = timeSourceService;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.newResult(new UniformPair<EventBean[]>(newData, oldData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newResult(UniformPair<EventBean[]> result) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            ViewSupport.dumpUpdateParams(".update for view " + this, result);
        }
        this.statementResultServiceImpl.indicate(result);
        if (!((Boolean)this.isDispatchWaiting.get()).booleanValue()) {
            UpdateDispatchFutureSpin nextFutureSpin;
            UpdateDispatchViewBlockingSpin updateDispatchViewBlockingSpin = this;
            synchronized (updateDispatchViewBlockingSpin) {
                this.currentFutureSpin = nextFutureSpin = new UpdateDispatchFutureSpin(this, this.currentFutureSpin, this.msecTimeout, this.timeSourceService);
            }
            this.dispatchService.addExternal(nextFutureSpin);
            this.isDispatchWaiting.set(true);
        }
    }
}

