/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodRow;
import com.espertech.esper.epl.agg.AggregationServiceBase;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggregationServiceGroupByRefcountedImpl
extends AggregationServiceBase {
    private Map<MultiKeyUntyped, AggregationMethodRow> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorRow;
    private MethodResolutionService methodResolutionService;
    private List<MultiKeyUntyped> removedKeys;

    public AggregationServiceGroupByRefcountedImpl(ExprEvaluator[] evaluators, AggregationMethod[] prototypes, MethodResolutionService methodResolutionService) {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<MultiKeyUntyped, AggregationMethodRow>();
        this.removedKeys = new ArrayList<MultiKeyUntyped>();
    }

    public void clearResults() {
        this.aggregatorsPerGroup.clear();
    }

    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        AggregationMethodRow row;
        if (!this.removedKeys.isEmpty()) {
            for (MultiKeyUntyped removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
            }
            this.removedKeys.clear();
        }
        if ((row = this.aggregatorsPerGroup.get(groupByKey)) == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
            row = new AggregationMethodRow(this.methodResolutionService.getCurrentRowCount(this.aggregators) + 1L, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            row.increaseRefcount();
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[j].enter(columnResult);
        }
    }

    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            groupAggregators = row.getMethods();
        } else {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
            row = new AggregationMethodRow(this.methodResolutionService.getCurrentRowCount(this.aggregators) + 1L, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[j].leave(columnResult);
        }
        row.decreaseRefcount();
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
            this.methodResolutionService.removeAggregators(groupByKey);
        }
    }

    public void setCurrentRow(MultiKeyUntyped groupByKey) {
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        this.currentAggregatorRow = row != null ? row.getMethods() : null;
        if (this.currentAggregatorRow == null) {
            this.currentAggregatorRow = this.methodResolutionService.newAggregators(this.aggregators, groupByKey);
        }
    }

    public Object getValue(int column) {
        return this.currentAggregatorRow[column].getValue();
    }
}

