/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognize;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationServiceMatchRecognizeImpl
implements AggregationServiceMatchRecognize {
    private ExprEvaluator[][] evaluatorsEachStream;
    private AggregationMethod[][] aggregatorsEachStream;
    private AggregationMethod[] aggregatorsAll;

    public AggregationServiceMatchRecognizeImpl(int countStreams, LinkedHashMap<Integer, AggregationMethod[]> aggregatorsPerStream, Map<Integer, ExprEvaluator[]> evaluatorsPerStream) {
        this.evaluatorsEachStream = new ExprEvaluator[countStreams][];
        this.aggregatorsEachStream = new AggregationMethod[countStreams][];
        int count = 0;
        for (Map.Entry<Integer, AggregationMethod[]> entry : aggregatorsPerStream.entrySet()) {
            this.aggregatorsEachStream[entry.getKey().intValue()] = entry.getValue();
            count += entry.getValue().length;
        }
        this.aggregatorsAll = new AggregationMethod[count];
        count = 0;
        for (Map.Entry<Integer, AggregationMethod[]> entry : aggregatorsPerStream.entrySet()) {
            for (AggregationMethod method : entry.getValue()) {
                this.aggregatorsAll[count++] = method;
            }
        }
        for (Map.Entry<Integer, Object[]> entry : evaluatorsPerStream.entrySet()) {
            this.evaluatorsEachStream[entry.getKey().intValue()] = (ExprEvaluator[])entry.getValue();
        }
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, int streamId, ExprEvaluatorContext exprEvaluatorContext) {
        ExprEvaluator[] evaluatorsStream = this.evaluatorsEachStream[streamId];
        if (evaluatorsStream == null) {
            return;
        }
        AggregationMethod[] aggregatorsStream = this.aggregatorsEachStream[streamId];
        for (int j = 0; j < evaluatorsStream.length; ++j) {
            Object columnResult = evaluatorsStream[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            aggregatorsStream[j].enter(columnResult);
        }
    }

    @Override
    public Object getValue(int column) {
        return this.aggregatorsAll[column].getValue();
    }

    @Override
    public void clearResults() {
        for (AggregationMethod aggregator : this.aggregatorsAll) {
            aggregator.clear();
        }
    }
}

