/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;

public class LongSumAggregator
implements AggregationMethod {
    private long sum;
    private long numDataPoints;

    public void clear() {
        this.sum = 0L;
        this.numDataPoints = 0L;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        this.sum += ((Long)object).longValue();
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        this.sum -= ((Long)object).longValue();
    }

    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return this.sum;
    }

    public Class getValueType() {
        return Long.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeSumAggregator(Long.class);
    }
}

