/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.collection.SortedRefCountedSet;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.type.MinMaxTypeEnum;

public class MinMaxAggregator
implements AggregationMethod {
    private final MinMaxTypeEnum minMaxTypeEnum;
    private final Class returnType;
    private SortedRefCountedSet<Object> refSet;

    public MinMaxAggregator(MinMaxTypeEnum minMaxTypeEnum, Class returnType) {
        this.minMaxTypeEnum = minMaxTypeEnum;
        this.returnType = returnType;
        this.refSet = new SortedRefCountedSet();
    }

    public void clear() {
        this.refSet.clear();
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        this.refSet.add(object);
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        this.refSet.remove(object);
    }

    public Object getValue() {
        if (this.minMaxTypeEnum == MinMaxTypeEnum.MAX) {
            return this.refSet.maxValue();
        }
        return this.refSet.minValue();
    }

    public Class getValueType() {
        return this.returnType;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeMinMaxAggregator(this.minMaxTypeEnum, this.returnType, true);
    }
}

