/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.type.MinMaxTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MinMaxEverAggregator
implements AggregationMethod {
    private static final Log log = LogFactory.getLog(MinMaxEverAggregator.class);
    private final MinMaxTypeEnum minMaxTypeEnum;
    private final Class returnType;
    private Comparable currentMinMax;

    public MinMaxEverAggregator(MinMaxTypeEnum minMaxTypeEnum, Class returnType) {
        this.minMaxTypeEnum = minMaxTypeEnum;
        this.returnType = returnType;
    }

    public void clear() {
        this.currentMinMax = null;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        if (this.currentMinMax == null) {
            this.currentMinMax = (Comparable)object;
            return;
        }
        if (this.minMaxTypeEnum == MinMaxTypeEnum.MAX) {
            if (this.currentMinMax.compareTo(object) < 0) {
                this.currentMinMax = (Comparable)object;
            }
        } else if (this.currentMinMax.compareTo(object) > 0) {
            this.currentMinMax = (Comparable)object;
        }
    }

    public void leave(Object object) {
        log.warn(".leave Received remove stream, none was expected");
    }

    public Object getValue() {
        return this.currentMinMax;
    }

    public Class getValueType() {
        return this.returnType;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeMinMaxAggregator(this.minMaxTypeEnum, this.returnType, false);
    }
}

