/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;

public class NthAggregator
implements AggregationMethod {
    private final Class returnType;
    private final int sizeBuf;
    private Object[] circularBuffer;
    private int currentBufferElementPointer;
    private long numDataPoints;

    public NthAggregator(Class returnType, int sizeBuf) {
        this.returnType = returnType;
        this.sizeBuf = sizeBuf;
    }

    public void enter(Object value) {
        Object[] arr = (Object[])value;
        ++this.numDataPoints;
        if (this.circularBuffer == null) {
            this.clear();
        }
        this.circularBuffer[this.currentBufferElementPointer] = arr[0];
        this.currentBufferElementPointer = (this.currentBufferElementPointer + 1) % this.sizeBuf;
    }

    public void leave(Object value) {
        --this.numDataPoints;
        if ((long)this.sizeBuf > this.numDataPoints) {
            int diff = this.sizeBuf - (int)this.numDataPoints;
            this.circularBuffer[(this.currentBufferElementPointer + diff - 1) % this.sizeBuf] = null;
        }
    }

    public Class getValueType() {
        return this.returnType;
    }

    public Object getValue() {
        return this.circularBuffer[(this.currentBufferElementPointer + this.sizeBuf) % this.sizeBuf];
    }

    public void clear() {
        this.circularBuffer = new Object[this.sizeBuf];
        this.numDataPoints = 0L;
        this.currentBufferElementPointer = 0;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeNthAggregator(this.returnType, this.sizeBuf);
    }
}

