/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;

public class NumIntegerSumAggregator
implements AggregationMethod {
    private int sum;
    private long numDataPoints;

    public void clear() {
        this.sum = 0;
        this.numDataPoints = 0L;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        Number number = (Number)object;
        this.sum += number.intValue();
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        Number number = (Number)object;
        this.sum -= number.intValue();
    }

    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return this.sum;
    }

    public Class getValueType() {
        return Integer.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeSumAggregator(null);
    }
}

