/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;

public class StddevAggregator
implements AggregationMethod {
    private double sum;
    private double sumSq;
    private long numDataPoints;

    public void clear() {
        this.sum = 0.0;
        this.sumSq = 0.0;
        this.numDataPoints = 0L;
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        ++this.numDataPoints;
        this.sum += value;
        this.sumSq += value * value;
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        --this.numDataPoints;
        this.sum -= value;
        this.sumSq -= value * value;
    }

    public Object getValue() {
        if (this.numDataPoints < 2L) {
            return null;
        }
        double variance = (this.sumSq - this.sum * this.sum / (double)this.numDataPoints) / (double)(this.numDataPoints - 1L);
        return Math.sqrt(variance);
    }

    public Class getValueType() {
        return Double.class;
    }

    public AggregationMethod newAggregator(MethodResolutionService methodResolutionService) {
        return methodResolutionService.makeStddevAggregator();
    }
}

