/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.agg.AvedevAggregator;
import com.espertech.esper.epl.agg.AvgAggregator;
import com.espertech.esper.epl.agg.BigDecimalAvgAggregator;
import com.espertech.esper.epl.agg.BigDecimalSumAggregator;
import com.espertech.esper.epl.agg.BigIntegerSumAggregator;
import com.espertech.esper.epl.agg.CountAggregator;
import com.espertech.esper.epl.agg.DistinctValueAggregator;
import com.espertech.esper.epl.agg.DoubleSumAggregator;
import com.espertech.esper.epl.agg.FirstValueAggregator;
import com.espertech.esper.epl.agg.FloatSumAggregator;
import com.espertech.esper.epl.agg.IntegerSumAggregator;
import com.espertech.esper.epl.agg.LastValueAggregator;
import com.espertech.esper.epl.agg.LeavingAggregator;
import com.espertech.esper.epl.agg.LongSumAggregator;
import com.espertech.esper.epl.agg.MedianAggregator;
import com.espertech.esper.epl.agg.MinMaxAggregator;
import com.espertech.esper.epl.agg.MinMaxEverAggregator;
import com.espertech.esper.epl.agg.NonNullCountAggregator;
import com.espertech.esper.epl.agg.NthAggregator;
import com.espertech.esper.epl.agg.NumIntegerSumAggregator;
import com.espertech.esper.epl.agg.RateAggregator;
import com.espertech.esper.epl.agg.RateEverAggregator;
import com.espertech.esper.epl.agg.StddevAggregator;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.MinMaxTypeEnum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodResolutionServiceImpl
implements MethodResolutionService {
    private static final Log log = LogFactory.getLog(MethodResolutionServiceImpl.class);
    private final EngineImportService engineImportService;
    private final TimeProvider timeProvider;
    private final boolean isUdfCache;

    public MethodResolutionServiceImpl(EngineImportService engineImportService, TimeProvider timeProvider, boolean isUdfCache) {
        this.engineImportService = engineImportService;
        this.timeProvider = timeProvider;
        this.isUdfCache = isUdfCache;
    }

    public boolean isUdfCache() {
        return this.isUdfCache;
    }

    public AggregationSupport makePlugInAggregator(String functionName) {
        try {
            return this.engineImportService.resolveAggregation(functionName);
        }
        catch (EngineImportUndefinedException e) {
            throw new EPException("Failed to make new aggregation function instance for '" + functionName + "'", e);
        }
        catch (EngineImportException e) {
            throw new EPException("Failed to make new aggregation function instance for '" + functionName + "'", e);
        }
    }

    public Method resolveMethod(String className, String methodName, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveMethod(className, methodName, paramTypes);
    }

    public Method resolveMethod(String className, String methodName) throws EngineImportException {
        return this.engineImportService.resolveMethod(className, methodName);
    }

    public Class resolveClass(String className) throws EngineImportException {
        return this.engineImportService.resolveClass(className);
    }

    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveMethod(clazz, methodName, paramTypes);
    }

    public AggregationMethod makeCountAggregator(boolean isIgnoreNull) {
        if (isIgnoreNull) {
            return new NonNullCountAggregator();
        }
        return new CountAggregator();
    }

    public AggregationSupport resolveAggregation(String functionName) throws EngineImportUndefinedException, EngineImportException {
        return this.engineImportService.resolveAggregation(functionName);
    }

    public AggregationMethod makeSumAggregator(Class type) {
        if (type == BigInteger.class) {
            return new BigIntegerSumAggregator();
        }
        if (type == BigDecimal.class) {
            return new BigDecimalSumAggregator();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongSumAggregator();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerSumAggregator();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleSumAggregator();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatSumAggregator();
        }
        return new NumIntegerSumAggregator();
    }

    public AggregationMethod makeDistinctAggregator(AggregationMethod aggregationMethod, Class childType) {
        return new DistinctValueAggregator(aggregationMethod, childType);
    }

    public AggregationMethod makeAvgAggregator(Class type) {
        if (type == BigDecimal.class || type == BigInteger.class) {
            return new BigDecimalAvgAggregator();
        }
        return new AvgAggregator();
    }

    public AggregationMethod makeAvedevAggregator() {
        return new AvedevAggregator();
    }

    public AggregationMethod makeMedianAggregator() {
        return new MedianAggregator();
    }

    public AggregationMethod makeMinMaxAggregator(MinMaxTypeEnum minMaxTypeEnum, Class targetType, boolean isHasDataWindows) {
        if (!isHasDataWindows) {
            return new MinMaxEverAggregator(minMaxTypeEnum, targetType);
        }
        return new MinMaxAggregator(minMaxTypeEnum, targetType);
    }

    public AggregationMethod makeStddevAggregator() {
        return new StddevAggregator();
    }

    public AggregationMethod makeFirstValueAggregator(Class type) {
        return new FirstValueAggregator(type);
    }

    public AggregationMethod makeLastValueAggregator(Class type) {
        return new LastValueAggregator(type);
    }

    public AggregationMethod makeRateAggregator() {
        return new RateAggregator();
    }

    public AggregationMethod makeRateEverAggregator(long interval) {
        return new RateEverAggregator(interval, this.timeProvider);
    }

    public AggregationMethod makeNthAggregator(Class returnType, int size) {
        return new NthAggregator(returnType, size);
    }

    public AggregationMethod makeLeavingAggregator() {
        return new LeavingAggregator();
    }

    public void setGroupKeyTypes(Class[] groupKeyTypes) {
        if (log.isDebugEnabled()) {
            log.debug("Group key typed are " + Arrays.toString(groupKeyTypes));
        }
    }

    public AggregationMethod[] newAggregators(AggregationMethod[] prototypes, MultiKeyUntyped groupKey) {
        AggregationMethod[] row = new AggregationMethod[prototypes.length];
        for (int i = 0; i < prototypes.length; ++i) {
            row[i] = prototypes[i].newAggregator(this);
        }
        return row;
    }

    public long getCurrentRowCount(AggregationMethod[] aggregators) {
        return 0L;
    }

    public void removeAggregators(MultiKeyUntyped groupKey) {
    }
}

