/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.MetaDefItem;
import com.espertech.esper.util.MultiKeyCollatingComparator;
import com.espertech.esper.util.MultiKeyComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByProcessorImpl
implements OrderByProcessor {
    private static final Log log = LogFactory.getLog(OrderByProcessorImpl.class);
    private final List<OrderByItem> orderByList;
    private final List<ExprNode> groupByNodes;
    private final boolean needsGroupByKeys;
    private final AggregationService aggregationService;
    private final Comparator<MultiKeyUntyped> comparator;

    public OrderByProcessorImpl(List<OrderByItem> orderByList, List<ExprNode> groupByNodes, boolean needsGroupByKeys, AggregationService aggregationService, boolean isSortUsingCollator) throws ExprValidationException {
        this.orderByList = orderByList;
        this.groupByNodes = groupByNodes;
        this.needsGroupByKeys = needsGroupByKeys;
        this.aggregationService = aggregationService;
        this.comparator = OrderByProcessorImpl.getComparator(orderByList, isSortUsingCollator);
    }

    @Override
    public MultiKeyUntyped getSortKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] values = new Object[this.orderByList.size()];
        int count = 0;
        for (OrderByItem sortPair : this.orderByList) {
            ExprNode sortNode = sortPair.getExprNode();
            values[count++] = sortNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return new MultiKeyUntyped(values);
    }

    @Override
    public MultiKeyUntyped[] getSortKeyPerRow(EventBean[] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (generatingEvents == null) {
            return null;
        }
        MultiKeyUntyped[] sortProperties = new MultiKeyUntyped[generatingEvents.length];
        int count = 0;
        EventBean[] evalEventsPerStream = new EventBean[1];
        for (EventBean event : generatingEvents) {
            Object[] values = new Object[this.orderByList.size()];
            int countTwo = 0;
            evalEventsPerStream[0] = event;
            for (OrderByItem sortPair : this.orderByList) {
                ExprNode sortNode = sortPair.getExprNode();
                values[countTwo++] = sortNode.evaluate(evalEventsPerStream, isNewData, exprEvaluatorContext);
            }
            sortProperties[count] = new MultiKeyUntyped(values);
            ++count;
        }
        return sortProperties;
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        MultiKeyUntyped[] groupByKeys = null;
        if (this.needsGroupByKeys) {
            groupByKeys = this.generateGroupKeys(generatingEvents, isNewData, exprEvaluatorContext);
        }
        return this.sort(outgoingEvents, generatingEvents, groupByKeys, isNewData, exprEvaluatorContext);
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, EventBean[][] generatingEvents, MultiKeyUntyped[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sort");
        }
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        List<MultiKeyUntyped> sortValuesMultiKeys = this.createSortProperties(generatingEvents, groupByKeys, isNewData, exprEvaluatorContext);
        HashMap<MultiKeyUntyped, ArrayList<EventBean>> sortToOutgoing = new HashMap<MultiKeyUntyped, ArrayList<EventBean>>();
        int countOne = 0;
        for (MultiKeyUntyped sortValues : sortValuesMultiKeys) {
            ArrayList<EventBean> list = (ArrayList<EventBean>)sortToOutgoing.get(sortValues);
            if (list == null) {
                list = new ArrayList<EventBean>();
            }
            list.add(outgoingEvents[countOne++]);
            sortToOutgoing.put(sortValues, list);
        }
        Collections.sort(sortValuesMultiKeys, this.comparator);
        LinkedHashSet<MultiKeyUntyped> sortSet = new LinkedHashSet<MultiKeyUntyped>(sortValuesMultiKeys);
        EventBean[] result = new EventBean[outgoingEvents.length];
        int countTwo = 0;
        for (MultiKeyUntyped sortValues : sortSet) {
            Collection output = (Collection)sortToOutgoing.get(sortValues);
            for (EventBean event : output) {
                result[countTwo++] = event;
            }
        }
        return result;
    }

    private List<MultiKeyUntyped> createSortProperties(EventBean[][] generatingEvents, MultiKeyUntyped[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        MultiKeyUntyped[] sortProperties = new MultiKeyUntyped[generatingEvents.length];
        int count = 0;
        for (EventBean[] eventsPerStream : generatingEvents) {
            if (this.needsGroupByKeys) {
                this.aggregationService.setCurrentRow(groupByKeys[count]);
            }
            Object[] values = new Object[this.orderByList.size()];
            int countTwo = 0;
            for (OrderByItem sortPair : this.orderByList) {
                ExprNode sortNode = sortPair.getExprNode();
                values[countTwo++] = sortNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            }
            sortProperties[count] = new MultiKeyUntyped(values);
            ++count;
        }
        return Arrays.asList(sortProperties);
    }

    private MultiKeyUntyped generateGroupKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] keys = new Object[this.groupByNodes.size()];
        int count = 0;
        for (ExprNode exprNode : this.groupByNodes) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    @Override
    public EventBean[] sort(EventBean[] outgoingEvents, MultiKeyUntyped[] orderKeys, ExprEvaluatorContext exprEvaluatorContext) {
        TreeMap<MultiKeyUntyped, Object> sort = new TreeMap<MultiKeyUntyped, Object>(this.comparator);
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        for (int i = 0; i < outgoingEvents.length; ++i) {
            ArrayList<EventBean> list;
            Object entry = sort.get(orderKeys[i]);
            if (entry == null) {
                sort.put(orderKeys[i], outgoingEvents[i]);
                continue;
            }
            if (entry instanceof EventBean) {
                list = new ArrayList<EventBean>();
                list.add((EventBean)entry);
                list.add(outgoingEvents[i]);
                sort.put(orderKeys[i], list);
                continue;
            }
            list = (ArrayList<EventBean>)entry;
            list.add(outgoingEvents[i]);
        }
        EventBean[] result = new EventBean[outgoingEvents.length];
        int count = 0;
        for (Object entry : sort.values()) {
            if (entry instanceof List) {
                List output = (List)entry;
                for (EventBean event : output) {
                    result[count++] = event;
                }
                continue;
            }
            result[count++] = (EventBean)entry;
        }
        return result;
    }

    private MultiKeyUntyped[] generateGroupKeys(EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        MultiKeyUntyped[] keys = new MultiKeyUntyped[generatingEvents.length];
        int count = 0;
        for (EventBean[] eventsPerStream : generatingEvents) {
            keys[count++] = this.generateGroupKey(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return keys;
    }

    protected static Comparator<MultiKeyUntyped> getComparator(List<OrderByItem> orderByList, boolean isSortUsingCollator) throws ExprValidationException {
        MetaDefItem comparator;
        if (isSortUsingCollator) {
            boolean hasStringTypes = false;
            boolean[] stringTypes = new boolean[orderByList.size()];
            int count = 0;
            for (OrderByItem item : orderByList) {
                if (item.getExprNode().getType() == String.class) {
                    hasStringTypes = true;
                    stringTypes[count] = true;
                }
                ++count;
            }
            comparator = !hasStringTypes ? new MultiKeyComparator(OrderByProcessorImpl.getIsDescendingValues(orderByList)) : new MultiKeyCollatingComparator(OrderByProcessorImpl.getIsDescendingValues(orderByList), stringTypes);
        } else {
            comparator = new MultiKeyComparator(OrderByProcessorImpl.getIsDescendingValues(orderByList));
        }
        return comparator;
    }

    private static boolean[] getIsDescendingValues(List<OrderByItem> orderByList) {
        boolean[] isDescendingValues = new boolean[orderByList.size()];
        int count = 0;
        for (OrderByItem pair : orderByList) {
            isDescendingValues[count++] = pair.isDescending();
        }
        return isDescendingValues;
    }
}

