/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.event.EventBeanUtility;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultSetProcessorBaseSimple
implements ResultSetProcessor {
    private static final Log log = LogFactory.getLog(ResultSetProcessorBaseSimple.class);

    @Override
    public void clear() {
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType != OutputLimitLimitType.LAST) {
            UniformPair<Set<MultiKey<EventBean>>> flattened = EventBeanUtility.flattenBatchJoin(joinEventsSet);
            return this.processJoinResult(flattened.getFirst(), flattened.getSecond(), generateSynthetic);
        }
        EventBean lastNonEmptyNew = null;
        EventBean lastNonEmptyOld = null;
        for (int index = joinEventsSet.size() - 1; index >= 0; --index) {
            UniformPair<Set<MultiKey<EventBean>>> pair = joinEventsSet.get(index);
            if (pair.getFirst() != null && !pair.getFirst().isEmpty() && lastNonEmptyNew == null || pair.getSecond() != null && !pair.getSecond().isEmpty() && lastNonEmptyOld == null) {
                UniformPair<EventBean[]> result = this.processJoinResult(pair.getFirst(), pair.getSecond(), generateSynthetic);
                if (lastNonEmptyNew == null && result != null && result.getFirst() != null && result.getFirst().length > 0) {
                    lastNonEmptyNew = result.getFirst()[result.getFirst().length - 1];
                }
                if (lastNonEmptyOld == null && result != null && result.getSecond() != null && result.getSecond().length > 0) {
                    lastNonEmptyOld = result.getSecond()[result.getSecond().length - 1];
                }
            }
            if (lastNonEmptyNew != null && lastNonEmptyOld != null) break;
        }
        EventBean[] lastNew = null;
        if (lastNonEmptyNew != null) {
            lastNew = new EventBean[]{lastNonEmptyNew};
        }
        EventBean[] lastOld = null;
        if (lastNonEmptyOld != null) {
            lastOld = new EventBean[]{lastNonEmptyOld};
        }
        return new UniformPair<Object>(lastNew, lastOld);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType != OutputLimitLimitType.LAST) {
            UniformPair<EventBean[]> pair = EventBeanUtility.flattenBatchStream(viewEventsList);
            return this.processViewResult(pair.getFirst(), pair.getSecond(), generateSynthetic);
        }
        EventBean lastNonEmptyNew = null;
        EventBean lastNonEmptyOld = null;
        for (int index = viewEventsList.size() - 1; index >= 0; --index) {
            UniformPair<EventBean[]> pair = viewEventsList.get(index);
            if (pair.getFirst() != null && pair.getFirst().length != 0 && lastNonEmptyNew == null || pair.getSecond() != null && pair.getSecond().length != 0 && lastNonEmptyOld == null) {
                UniformPair<EventBean[]> result = this.processViewResult(pair.getFirst(), pair.getSecond(), generateSynthetic);
                if (lastNonEmptyNew == null && result != null && result.getFirst() != null && result.getFirst().length > 0) {
                    lastNonEmptyNew = result.getFirst()[result.getFirst().length - 1];
                }
                if (lastNonEmptyOld == null && result != null && result.getSecond() != null && result.getSecond().length > 0) {
                    lastNonEmptyOld = result.getSecond()[result.getSecond().length - 1];
                }
            }
            if (lastNonEmptyNew != null && lastNonEmptyOld != null) break;
        }
        EventBean[] lastNew = null;
        if (lastNonEmptyNew != null) {
            lastNew = new EventBean[]{lastNonEmptyNew};
        }
        EventBean[] lastOld = null;
        if (lastNonEmptyOld != null) {
            lastOld = new EventBean[]{lastNonEmptyOld};
        }
        return new UniformPair<Object>(lastNew, lastOld);
    }
}

