/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.agg.AggregationServiceFactory;
import com.espertech.esper.epl.core.ColumnNamedNodeSwapper;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorFactory;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAll;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGrouped;
import com.espertech.esper.epl.core.ResultSetProcessorHandThrough;
import com.espertech.esper.epl.core.ResultSetProcessorRowForAll;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroup;
import com.espertech.esper.epl.core.ResultSetProcessorSimple;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypesException;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprNodeSubselectVisitor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.event.NativeEventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorFactory {
    private static final Log log = LogFactory.getLog(ResultSetProcessorFactory.class);

    public static ResultSetProcessor getProcessor(StatementSpecCompiled statementSpecCompiled, StatementContext stmtContext, StreamTypeService typeService, ViewResourceDelegate viewResourceDelegate, boolean[] isUnidirectionalStream, boolean allowAggregation) throws ExprValidationException {
        boolean hasAggregation;
        boolean isLast;
        boolean isOutputLimiting;
        boolean isSelectRStream;
        SelectClauseSpecCompiled selectClauseSpec = statementSpecCompiled.getSelectClauseSpec();
        InsertIntoDesc insertIntoDesc = statementSpecCompiled.getInsertIntoDesc();
        List<ExprNode> groupByNodes = statementSpecCompiled.getGroupByExpressions();
        ExprNode optionalHavingNode = statementSpecCompiled.getHavingExprRootNode();
        OutputLimitSpec outputLimitSpec = statementSpecCompiled.getOutputLimitSpec();
        List<OrderByItem> orderByList = statementSpecCompiled.getOrderByList();
        if (log.isDebugEnabled()) {
            log.debug(".getProcessor Getting processor for  selectionList=" + selectClauseSpec.getSelectExprList() + " groupByNodes=" + Arrays.toString(groupByNodes.toArray()) + " optionalHavingNode=" + optionalHavingNode);
        }
        boolean isUnidirectional = false;
        for (int i = 0; i < isUnidirectionalStream.length; ++i) {
            isUnidirectional |= isUnidirectionalStream[i];
        }
        ResultSetProcessorFactory.expandColumnNames(selectClauseSpec.getSelectExprList(), orderByList);
        LinkedList<SelectClauseExprCompiledSpec> namedSelectionList = new LinkedList<SelectClauseExprCompiledSpec>();
        for (int i = 0; i < selectClauseSpec.getSelectExprList().size(); ++i) {
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList().get(i);
            if (!(element instanceof SelectClauseExprCompiledSpec)) continue;
            SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
            ExprNode validatedExpression = expr.getSelectExpression().getValidatedSubtree(typeService, stmtContext.getMethodResolutionService(), viewResourceDelegate, stmtContext.getSchedulingService(), stmtContext.getVariableService(), stmtContext);
            String asName = expr.getAssignedName();
            if (asName == null) {
                asName = validatedExpression.toExpressionString();
            }
            expr.setAssignedName(asName);
            expr.setSelectExpression(validatedExpression);
            namedSelectionList.add(expr);
        }
        boolean isUsingWildcard = selectClauseSpec.isUsingWildcard();
        boolean isUsingStreamSelect = false;
        for (SelectClauseElementCompiled compiled : selectClauseSpec.getSelectExprList()) {
            if (!(compiled instanceof SelectClauseStreamCompiledSpec)) continue;
            SelectClauseStreamCompiledSpec streamSelectSpec = (SelectClauseStreamCompiledSpec)compiled;
            int streamNum = Integer.MIN_VALUE;
            boolean isFragmentEvent = false;
            boolean isProperty = false;
            Class propertyType = null;
            isUsingStreamSelect = true;
            for (int i = 0; i < typeService.getStreamNames().length; ++i) {
                String streamName = streamSelectSpec.getStreamName();
                if (typeService.getStreamNames()[i].equals(streamName)) {
                    streamNum = i;
                    break;
                }
                EventType candidateProviderOfFragments = typeService.getEventTypes()[i];
                if (candidateProviderOfFragments instanceof NativeEventType || candidateProviderOfFragments.getFragmentType(streamName) == null) continue;
                streamNum = i;
                isFragmentEvent = true;
                break;
            }
            if (streamNum == Integer.MIN_VALUE) {
                PropertyResolutionDescriptor desc = null;
                try {
                    desc = typeService.resolveByPropertyName(streamSelectSpec.getStreamName());
                }
                catch (StreamTypesException e) {
                    // empty catch block
                }
                if (desc == null) {
                    throw new ExprValidationException("Stream selector '" + streamSelectSpec.getStreamName() + ".*' does not match any stream name in the from clause");
                }
                isProperty = true;
                propertyType = desc.getPropertyType();
                streamNum = desc.getStreamNum();
            }
            streamSelectSpec.setStreamNumber(streamNum);
            streamSelectSpec.setFragmentEvent(isFragmentEvent);
            streamSelectSpec.setProperty(isProperty, propertyType);
        }
        Class[] groupByTypes = new Class[groupByNodes.size()];
        for (int i = 0; i < groupByNodes.size(); ++i) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            groupByNodes.get(i).accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within group-by");
            }
            ExprNode validatedGroupBy = groupByNodes.get(i).getValidatedSubtree(typeService, stmtContext.getMethodResolutionService(), viewResourceDelegate, stmtContext.getSchedulingService(), stmtContext.getVariableService(), stmtContext);
            groupByNodes.set(i, validatedGroupBy);
            groupByTypes[i] = validatedGroupBy.getType();
        }
        stmtContext.getMethodResolutionService().setGroupKeyTypes(groupByTypes);
        if (optionalHavingNode != null) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            optionalHavingNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within having-clause");
            }
            optionalHavingNode = optionalHavingNode.getValidatedSubtree(typeService, stmtContext.getMethodResolutionService(), viewResourceDelegate, stmtContext.getSchedulingService(), stmtContext.getVariableService(), stmtContext);
        }
        for (int i = 0; i < orderByList.size(); ++i) {
            ExprNode orderByNode = orderByList.get(i).getExprNode();
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            orderByNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within order-by clause");
            }
            Boolean isDescending = orderByList.get(i).isDescending();
            OrderByItem validatedOrderBy = new OrderByItem(orderByNode.getValidatedSubtree(typeService, stmtContext.getMethodResolutionService(), viewResourceDelegate, stmtContext.getSchedulingService(), stmtContext.getVariableService(), stmtContext), isDescending);
            orderByList.set(i, validatedOrderBy);
        }
        ArrayList<ExprNode> selectNodes = new ArrayList<ExprNode>();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            selectNodes.add(element.getSelectExpression());
        }
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        LinkedList<ExprAggregateNode> selectAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            ExprAggregateNode.getAggregatesBottomUp(element.getSelectExpression(), selectAggregateExprNodes);
        }
        if (!allowAggregation && !selectAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> havingAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        Set<Object> propertiesAggregatedHaving = new HashSet();
        if (optionalHavingNode != null) {
            ExprAggregateNode.getAggregatesBottomUp(optionalHavingNode, havingAggregateExprNodes);
            propertiesAggregatedHaving = ResultSetProcessorFactory.getAggregatedProperties(havingAggregateExprNodes);
        }
        if (!allowAggregation && !havingAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> orderByAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        if (orderByNodes != null) {
            for (ExprNode orderByNode : orderByNodes) {
                ExprAggregateNode.getAggregatesBottomUp(orderByNode, orderByAggregateExprNodes);
            }
            if (!allowAggregation && !orderByAggregateExprNodes.isEmpty()) {
                throw new ExprValidationException("Aggregation functions are not allowed in this context");
            }
        }
        boolean hasGroupBy = !groupByNodes.isEmpty();
        AggregationService aggregationService = AggregationServiceFactory.getService(selectAggregateExprNodes, havingAggregateExprNodes, orderByAggregateExprNodes, hasGroupBy, stmtContext.getMethodResolutionService(), stmtContext, statementSpecCompiled.getAnnotations(), stmtContext.getVariableService(), stmtContext.getStatementStopService());
        boolean useCollatorSort = false;
        if (stmtContext.getConfigSnapshot() != null) {
            useCollatorSort = stmtContext.getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
        OrderByProcessor orderByProcessor = OrderByProcessorFactory.getProcessor(namedSelectionList, groupByNodes, orderByList, aggregationService, statementSpecCompiled.getRowLimitSpec(), stmtContext.getVariableService(), useCollatorSort);
        SelectExprEventTypeRegistry selectExprEventTypeRegistry = new SelectExprEventTypeRegistry(stmtContext.getDynamicReferenceEventTypes());
        SelectExprProcessor selectExprProcessor = SelectExprProcessorFactory.getProcessor(selectClauseSpec.getSelectExprList(), isUsingWildcard, insertIntoDesc, typeService, stmtContext.getEventAdapterService(), stmtContext.getStatementResultService(), stmtContext.getValueAddEventService(), selectExprEventTypeRegistry, stmtContext.getMethodResolutionService(), stmtContext);
        Set<Pair<Integer, String>> propertiesGroupBy = ResultSetProcessorFactory.getGroupByProperties(groupByNodes);
        Set<Pair<Integer, String>> nonAggregatedProps = ResultSetProcessorFactory.getNonAggregatedProps(selectNodes);
        ResultSetProcessorFactory.validateGroupBy(groupByNodes);
        if (optionalHavingNode != null) {
            ResultSetProcessorFactory.validateHaving(propertiesGroupBy, optionalHavingNode);
        }
        boolean bl = isSelectRStream = statementSpecCompiled.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH || statementSpecCompiled.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY;
        if (statementSpecCompiled.getInsertIntoDesc() != null && !statementSpecCompiled.getInsertIntoDesc().isIStream()) {
            isSelectRStream = true;
        }
        boolean bl2 = isOutputLimiting = outputLimitSpec != null;
        if (outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT) {
            isOutputLimiting = false;
        }
        if (groupByNodes.isEmpty() && selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            if (orderByNodes.isEmpty() && optionalHavingNode == null && !isOutputLimiting && statementSpecCompiled.getRowLimitSpec() == null) {
                log.debug(".getProcessor Using no result processor");
                return new ResultSetProcessorHandThrough(selectExprProcessor, isSelectRStream);
            }
            log.debug(".getProcessor Using ResultSetProcessorSimple");
            return new ResultSetProcessorSimple(selectExprProcessor, orderByProcessor, optionalHavingNode, isSelectRStream, stmtContext);
        }
        boolean bl3 = isLast = statementSpecCompiled.getOutputLimitSpec() != null && statementSpecCompiled.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.LAST;
        if (namedSelectionList.isEmpty() && propertiesAggregatedHaving.isEmpty() && havingAggregateExprNodes.isEmpty() && !isLast) {
            log.debug(".getProcessor Using ResultSetProcessorSimple");
            return new ResultSetProcessorSimple(selectExprProcessor, orderByProcessor, optionalHavingNode, isSelectRStream, stmtContext);
        }
        boolean bl4 = hasAggregation = !selectAggregateExprNodes.isEmpty() || !propertiesAggregatedHaving.isEmpty();
        if (groupByNodes.isEmpty() && hasAggregation) {
            if (nonAggregatedProps.isEmpty() && !isUsingWildcard && !isUsingStreamSelect) {
                log.debug(".getProcessor Using ResultSetProcessorRowForAll");
                return new ResultSetProcessorRowForAll(selectExprProcessor, aggregationService, orderByProcessor, optionalHavingNode, isSelectRStream, isUnidirectional, stmtContext);
            }
            log.debug(".getProcessor Using ResultSetProcessorAggregateAll");
            return new ResultSetProcessorAggregateAll(selectExprProcessor, orderByProcessor, aggregationService, optionalHavingNode, isSelectRStream, isUnidirectional, stmtContext);
        }
        if (groupByNodes.isEmpty()) {
            throw new IllegalStateException("Unexpected empty group-by expression list");
        }
        Set<Pair<Integer, String>> nonAggregatedPropsSelect = ResultSetProcessorFactory.getNonAggregatedProps(selectNodes);
        boolean allInGroupBy = true;
        for (Pair<Integer, String> nonAggregatedProp : nonAggregatedPropsSelect) {
            if (propertiesGroupBy.contains(nonAggregatedProp)) continue;
            allInGroupBy = false;
        }
        if (isUsingWildcard) {
            allInGroupBy = false;
        }
        Set<Pair<Integer, String>> nonAggregatedPropsOrderBy = ResultSetProcessorFactory.getNonAggregatedProps(orderByNodes);
        boolean allInSelect = true;
        for (Pair<Integer, String> nonAggregatedProp : nonAggregatedPropsOrderBy) {
            if (nonAggregatedPropsSelect.contains(nonAggregatedProp)) continue;
            allInSelect = false;
        }
        if (isUsingWildcard) {
            allInSelect = true;
        }
        if (allInGroupBy && allInSelect) {
            log.debug(".getProcessor Using ResultSetProcessorRowPerGroup");
            return new ResultSetProcessorRowPerGroup(selectExprProcessor, orderByProcessor, aggregationService, groupByNodes, optionalHavingNode, isSelectRStream, isUnidirectional, stmtContext);
        }
        log.debug(".getProcessor Using ResultSetProcessorAggregateGrouped");
        return new ResultSetProcessorAggregateGrouped(selectExprProcessor, orderByProcessor, aggregationService, groupByNodes, optionalHavingNode, isSelectRStream, isUnidirectional, stmtContext);
    }

    private static void validateHaving(Set<Pair<Integer, String>> propertiesGroupedBy, ExprNode havingNode) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodesHaving = new LinkedList<ExprAggregateNode>();
        if (aggregateNodesHaving != null) {
            ExprAggregateNode.getAggregatesBottomUp(havingNode, aggregateNodesHaving);
        }
        if (!propertiesGroupedBy.isEmpty()) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            havingNode.accept(visitor);
            List<Pair<Integer, String>> allPropertiesHaving = visitor.getExprProperties();
            Set<Pair<Integer, String>> aggPropertiesHaving = ResultSetProcessorFactory.getAggregatedProperties(aggregateNodesHaving);
            allPropertiesHaving.removeAll(aggPropertiesHaving);
            allPropertiesHaving.removeAll(propertiesGroupedBy);
            if (!allPropertiesHaving.isEmpty()) {
                String name = allPropertiesHaving.iterator().next().getSecond();
                throw new ExprValidationException("Non-aggregated property '" + name + "' in the HAVING clause must occur in the group-by clause");
            }
        }
    }

    private static void validateGroupBy(List<ExprNode> groupByNodes) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggNodes = new LinkedList<ExprAggregateNode>();
        for (ExprNode groupByNode : groupByNodes) {
            ExprAggregateNode.getAggregatesBottomUp(groupByNode, aggNodes);
            if (aggNodes.isEmpty()) continue;
            throw new ExprValidationException("Group-by expressions cannot contain aggregate functions");
        }
    }

    private static Set<Pair<Integer, String>> getNonAggregatedProps(List<ExprNode> exprNodes) {
        HashSet<Pair<Integer, String>> nonAggProps = new HashSet<Pair<Integer, String>>();
        for (ExprNode node : exprNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(false);
            node.accept(visitor);
            List<Pair<Integer, String>> propertiesNode = visitor.getExprProperties();
            nonAggProps.addAll(propertiesNode);
        }
        return nonAggProps;
    }

    private static Set<Pair<Integer, String>> getAggregatedProperties(List<ExprAggregateNode> aggregateNodes) {
        HashSet<Pair<Integer, String>> propertiesAggregated = new HashSet<Pair<Integer, String>>();
        for (ExprAggregateNode selectAggExprNode : aggregateNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            selectAggExprNode.accept(visitor);
            List<Pair<Integer, String>> properties = visitor.getExprProperties();
            propertiesAggregated.addAll(properties);
        }
        return propertiesAggregated;
    }

    private static Set<Pair<Integer, String>> getGroupByProperties(List<ExprNode> groupByNodes) throws ExprValidationException {
        HashSet<Pair<Integer, String>> propertiesGroupBy = new HashSet<Pair<Integer, String>>();
        for (ExprNode groupByNode : groupByNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            groupByNode.accept(visitor);
            List<Pair<Integer, String>> propertiesNode = visitor.getExprProperties();
            propertiesGroupBy.addAll(propertiesNode);
            if (!propertiesNode.isEmpty()) continue;
            throw new ExprValidationException("Group-by expressions must refer to property names");
        }
        return propertiesGroupBy;
    }

    private static void expandColumnNames(List<SelectClauseElementCompiled> selectionList, List<OrderByItem> orderByList) {
        for (SelectClauseElementCompiled selectElement : selectionList) {
            SelectClauseExprCompiledSpec selectExpr;
            String name;
            if (!(selectElement instanceof SelectClauseExprCompiledSpec) || (name = (selectExpr = (SelectClauseExprCompiledSpec)selectElement).getAssignedName()) == null) continue;
            ExprNode fullExpr = selectExpr.getSelectExpression();
            ListIterator<OrderByItem> iterator = orderByList.listIterator();
            while (iterator.hasNext()) {
                OrderByItem orderByElement = iterator.next();
                ExprNode swapped = ColumnNamedNodeSwapper.swap(orderByElement.getExprNode(), name, fullExpr);
                OrderByItem newOrderByElement = new OrderByItem(swapped, orderByElement.isDescending());
                iterator.set(newOrderByElement);
            }
        }
    }
}

