/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetRowPerGroupIterator;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProcessorRowPerGroup
implements ResultSetProcessor {
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final AggregationService aggregationService;
    private final List<ExprNode> groupKeyNodes;
    private final ExprNode optionalHavingNode;
    private final boolean isSorting;
    private final boolean isSelectRStream;
    private final boolean isUnidirectional;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final Map<MultiKeyUntyped, EventBean[]> groupRepsView = new LinkedHashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> workCollection = new LinkedHashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> newGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, EventBean[]> oldGenerators = new HashMap<MultiKeyUntyped, EventBean[]>();

    public ResultSetProcessorRowPerGroup(SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, List<ExprNode> groupKeyNodes, ExprNode optionalHavingNode, boolean isSelectRStream, boolean isUnidirectional, ExprEvaluatorContext exprEvaluatorContext) {
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.groupKeyNodes = groupKeyNodes;
        this.optionalHavingNode = optionalHavingNode;
        this.isSorting = orderByProcessor != null;
        this.isSelectRStream = isSelectRStream;
        this.isUnidirectional = isUnidirectional;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int count;
        HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
        MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newEvents, keysAndEvents, true);
        MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldEvents, keysAndEvents, false);
        if (this.isUnidirectional) {
            this.clear();
        }
        EventBean[] selectOldEvents = null;
        if (this.isSelectRStream) {
            selectOldEvents = this.generateOutputEventsJoin(keysAndEvents, this.oldGenerators, false, isSynthesize);
        }
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataMultiKey[count], this.exprEvaluatorContext);
                ++count;
            }
        }
        if (!oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataMultiKey[count], this.exprEvaluatorContext);
                ++count;
            }
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, this.newGenerators, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        HashMap<MultiKeyUntyped, EventBean> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean>();
        MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
        MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
        EventBean[] selectOldEvents = null;
        if (this.isSelectRStream) {
            selectOldEvents = this.generateOutputEventsView(keysAndEvents, this.oldGenerators, false, isSynthesize);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.exprEvaluatorContext);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsView(keysAndEvents, this.newGenerators, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    private EventBean[] generateOutputEventsView(Map<MultiKeyUntyped, EventBean> keysAndEvents, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData, boolean isSynthesize) {
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[keysAndEvents.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<MultiKeyUntyped, EventBean> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentRow(entry.getKey());
            eventsPerStream[0] = entry.getValue();
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize);
            keys[count] = entry.getKey();
            if (this.isSorting) {
                EventBean[] currentEventsPerStream = new EventBean[]{entry.getValue()};
                generators.put(keys[count], currentEventsPerStream);
                currentGenerators[count] = currentEventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.isSorting) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.exprEvaluatorContext);
        }
        return events;
    }

    private void generateOutputBatched(Map<MultiKeyUntyped, EventBean> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] eventsPerStream = new EventBean[1];
        for (Map.Entry<MultiKeyUntyped, EventBean> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentRow(entry.getKey());
            eventsPerStream[0] = entry.getValue();
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize));
            if (!this.isSorting) continue;
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    private void generateOutputBatchedArr(Map<MultiKeyUntyped, EventBean[]> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys) {
        for (Map.Entry<MultiKeyUntyped, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            EventBean[] eventsPerStream = entry.getValue();
            this.aggregationService.setCurrentRow(entry.getKey());
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize));
            if (!this.isSorting) continue;
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.exprEvaluatorContext));
        }
    }

    private EventBean[] generateOutputEventsJoin(Map<MultiKeyUntyped, EventBean[]> keysAndEvents, Map<MultiKeyUntyped, EventBean[]> generators, boolean isNewData, boolean isSynthesize) {
        EventBean[] events = new EventBean[keysAndEvents.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.isSorting) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<MultiKeyUntyped, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentRow(entry.getKey());
            EventBean[] eventsPerStream = entry.getValue();
            if (this.optionalHavingNode != null && ((result = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize);
            keys[count] = entry.getKey();
            if (this.isSorting) {
                generators.put(keys[count], eventsPerStream);
                currentGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.isSorting) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.isSorting) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.exprEvaluatorContext);
        }
        return events;
    }

    private MultiKeyUntyped[] generateGroupKeys(EventBean[] events, Map<MultiKeyUntyped, EventBean> eventPerKey, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
            eventPerKey.put(keys[i], events[i]);
        }
        return keys;
    }

    private MultiKeyUntyped[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, Map<MultiKeyUntyped, EventBean[]> eventPerKey, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            eventPerKey.put(keys[count], eventsPerStream.getArray());
            ++count;
        }
        return keys;
    }

    protected MultiKeyUntyped generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        Object[] keys = new Object[this.groupKeyNodes.size()];
        int count = 0;
        for (ExprNode exprNode : this.groupKeyNodes) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    public ExprNode getOptionalHavingNode() {
        return this.optionalHavingNode;
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetRowPerGroupIterator(parent.iterator(), this, this.aggregationService, this.exprEvaluatorContext);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
        HashSet<MultiKeyUntyped> priorSeenGroups = new HashSet<MultiKeyUntyped>();
        Iterator<EventBean> i$ = parent.iterator();
        while (i$.hasNext()) {
            EventBean candidate;
            eventsPerStream[0] = candidate = i$.next();
            MultiKeyUntyped groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentRow(groupKey);
            Boolean pass = true;
            if (this.optionalHavingNode != null) {
                pass = (Boolean)this.optionalHavingNode.evaluate(eventsPerStream, true, this.exprEvaluatorContext);
            }
            if (pass == null || !pass.booleanValue() || priorSeenGroups.contains(groupKey)) continue;
            priorSeenGroups.add(groupKey);
            outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true, true));
            MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.exprEvaluatorContext);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[outgoingEvents.size()]);
        MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[orderKeys.size()]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr, this.exprEvaluatorContext);
        return new ArrayEventIterator(orderedEvents);
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
        this.generateGroupKeys(joinSet, keysAndEvents, true);
        EventBean[] selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, this.newGenerators, true, true);
        return new ArrayEventIterator(selectNewEvents);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults();
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                int count;
                Set<MultiKey<EventBean>> newData = pair.getFirst();
                Set<MultiKey<EventBean>> oldData = pair.getSecond();
                if (this.isUnidirectional) {
                    this.clear();
                }
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
                if (this.isSelectRStream) {
                    this.generateOutputBatchedArr(keysAndEvents, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                this.generateOutputBatchedArr(keysAndEvents, true, generateSynthetic, newEvents, newEventsSortKey);
                keysAndEvents.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            if (this.isSelectRStream) {
                this.generateOutputBatchedArr(this.groupRepsView, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                MultiKeyUntyped mk;
                Set<MultiKey<EventBean>> newData = pair.getFirst();
                Set<MultiKey<EventBean>> oldData = pair.getSecond();
                if (this.isUnidirectional) {
                    this.clear();
                }
                if (newData != null) {
                    for (MultiKey<EventBean> aNewData : newData) {
                        mk = this.generateGroupKey(aNewData.getArray(), true);
                        if (this.groupRepsView.put(mk, aNewData.getArray()) == null) {
                            this.workCollection.clear();
                            this.workCollection.put(mk, aNewData.getArray());
                            if (this.isSelectRStream) {
                                this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                            }
                        }
                        this.aggregationService.applyEnter(aNewData.getArray(), mk, this.exprEvaluatorContext);
                    }
                }
                if (oldData == null) continue;
                for (MultiKey<EventBean> anOldData : oldData) {
                    mk = this.generateGroupKey(anOldData.getArray(), true);
                    if (this.groupRepsView.put(mk, anOldData.getArray()) == null) {
                        this.workCollection.clear();
                        this.workCollection.put(mk, anOldData.getArray());
                        if (this.isSelectRStream) {
                            this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                    }
                    this.aggregationService.applyLeave(anOldData.getArray(), mk, this.exprEvaluatorContext);
                }
            }
            this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.isSelectRStream) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<MultiKeyUntyped> newEventsSortKey = null;
        LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<MultiKeyUntyped>();
            if (this.isSelectRStream) {
                oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
            }
        }
        this.groupRepsView.clear();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            MultiKeyUntyped mk;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.isUnidirectional) {
                this.clear();
            }
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    mk = this.generateGroupKey(aNewData.getArray(), true);
                    if (this.groupRepsView.put(mk, aNewData.getArray()) == null) {
                        this.workCollection.clear();
                        this.workCollection.put(mk, aNewData.getArray());
                        if (this.isSelectRStream) {
                            this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                    }
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.exprEvaluatorContext);
                }
            }
            if (oldData == null) continue;
            for (MultiKey<EventBean> anOldData : oldData) {
                mk = this.generateGroupKey(anOldData.getArray(), true);
                if (this.groupRepsView.put(mk, anOldData.getArray()) == null) {
                    this.workCollection.clear();
                    this.workCollection.put(mk, anOldData.getArray());
                    if (this.isSelectRStream) {
                        this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                }
                this.aggregationService.applyLeave(anOldData.getArray(), mk, this.exprEvaluatorContext);
            }
        }
        this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.isSelectRStream) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.isSelectRStream) {
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            HashMap<MultiKeyUntyped, EventBean> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean>();
            for (UniformPair<EventBean[]> pair : viewEventsList) {
                int i$;
                int len$;
                EventBean[] arr$;
                int count;
                EventBean[] newData = pair.getFirst();
                EventBean[] oldData = pair.getSecond();
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
                if (this.isSelectRStream) {
                    this.generateOutputBatched(keysAndEvents, false, generateSynthetic, oldEvents, oldEventsSortKey, this.exprEvaluatorContext);
                }
                EventBean[] eventsPerStream = new EventBean[1];
                if (newData != null) {
                    count = 0;
                    arr$ = newData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean aNewData;
                        eventsPerStream[0] = aNewData = arr$[i$];
                        this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    arr$ = oldData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean anOldData;
                        eventsPerStream[0] = anOldData = arr$[i$];
                        this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.exprEvaluatorContext);
                        ++count;
                    }
                }
                this.generateOutputBatched(keysAndEvents, true, generateSynthetic, newEvents, newEventsSortKey, this.exprEvaluatorContext);
                keysAndEvents.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            EventBean[] eventsPerStream = new EventBean[1];
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.isSelectRStream) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.isSelectRStream) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            if (this.isSelectRStream) {
                this.generateOutputBatchedArr(this.groupRepsView, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            for (UniformPair<EventBean[]> pair : viewEventsList) {
                MultiKeyUntyped mk;
                int i$;
                int len$;
                EventBean[] arr$;
                EventBean[] newData = pair.getFirst();
                EventBean[] oldData = pair.getSecond();
                if (newData != null) {
                    arr$ = newData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean aNewData;
                        eventsPerStream[0] = aNewData = arr$[i$];
                        mk = this.generateGroupKey(eventsPerStream, true);
                        if (this.groupRepsView.put(mk, new EventBean[]{aNewData}) == null) {
                            this.workCollection.clear();
                            this.workCollection.put(mk, eventsPerStream);
                            if (this.isSelectRStream) {
                                this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                            }
                        }
                        this.aggregationService.applyEnter(eventsPerStream, mk, this.exprEvaluatorContext);
                    }
                }
                if (oldData == null) continue;
                arr$ = oldData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = arr$[i$];
                    mk = this.generateGroupKey(eventsPerStream, true);
                    if (this.groupRepsView.put(mk, new EventBean[]{anOldData}) == null) {
                        this.workCollection.clear();
                        this.workCollection.put(mk, eventsPerStream);
                        if (this.isSelectRStream) {
                            this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                    }
                    this.aggregationService.applyLeave(eventsPerStream, mk, this.exprEvaluatorContext);
                }
            }
            this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.isSelectRStream) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
                if (this.isSelectRStream) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.isSelectRStream) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<MultiKeyUntyped> newEventsSortKey = null;
        LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<MultiKeyUntyped>();
            if (this.isSelectRStream) {
                oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
            }
        }
        this.groupRepsView.clear();
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            MultiKeyUntyped mk;
            EventBean[] eventsPerStream;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    mk = this.generateGroupKey(eventsPerStream, true);
                    if (this.groupRepsView.put(mk, eventsPerStream) == null) {
                        this.workCollection.clear();
                        this.workCollection.put(mk, eventsPerStream);
                        if (this.isSelectRStream) {
                            this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                    }
                    this.aggregationService.applyEnter(eventsPerStream, mk, this.exprEvaluatorContext);
                }
            }
            if (oldData == null) continue;
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                mk = this.generateGroupKey(eventsPerStream, true);
                if (this.groupRepsView.put(mk, eventsPerStream) == null) {
                    this.workCollection.clear();
                    this.workCollection.put(mk, eventsPerStream);
                    if (this.isSelectRStream) {
                        this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                }
                this.aggregationService.applyLeave(eventsPerStream, mk, this.exprEvaluatorContext);
            }
        }
        this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.isSelectRStream) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.isSelectRStream) {
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }
}

