/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroup;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetRowPerGroupIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> sourceIterator;
    private final ResultSetProcessorRowPerGroup resultSetProcessor;
    private final AggregationService aggregationService;
    private EventBean nextResult;
    private final EventBean[] eventsPerStream;
    private final Set<MultiKeyUntyped> priorSeenGroups;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public ResultSetRowPerGroupIterator(Iterator<EventBean> sourceIterator, ResultSetProcessorRowPerGroup resultSetProcessor, AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext) {
        this.sourceIterator = sourceIterator;
        this.resultSetProcessor = resultSetProcessor;
        this.aggregationService = aggregationService;
        this.eventsPerStream = new EventBean[1];
        this.priorSeenGroups = new HashSet<MultiKeyUntyped>();
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            EventBean candidate;
            this.eventsPerStream[0] = candidate = this.sourceIterator.next();
            MultiKeyUntyped groupKey = this.resultSetProcessor.generateGroupKey(this.eventsPerStream, true);
            this.aggregationService.setCurrentRow(groupKey);
            Boolean pass = true;
            if (this.resultSetProcessor.getOptionalHavingNode() != null) {
                pass = (Boolean)this.resultSetProcessor.getOptionalHavingNode().evaluate(this.eventsPerStream, true, this.exprEvaluatorContext);
            }
            if (!pass.booleanValue() || this.priorSeenGroups.contains(groupKey)) continue;
            this.priorSeenGroups.add(groupKey);
            this.nextResult = this.resultSetProcessor.getSelectExprProcessor().process(this.eventsPerStream, true, true);
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

