/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprInsertEventBean;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.event.DecoratingEventBean;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprEvalProcessor
implements SelectExprProcessor {
    private static final Log log = LogFactory.getLog(SelectExprEvalProcessor.class);
    private ExprEvaluator[] expressionNodes;
    private String[] columnNames;
    private EventType resultEventType;
    private EventType vaeInnerEventType;
    private final EventAdapterService eventAdapterService;
    private boolean isUsingWildcard;
    private boolean singleStreamWrapper;
    private boolean singleColumnCoercion;
    private SelectExprJoinWildcardProcessor joinWildcardProcessor;
    private boolean isRevisionEvent;
    private ValueAddEventProcessor vaeProcessor;
    private boolean isEmptyExpressionNodes;
    private boolean isPopulateUnderlying;
    private SelectExprInsertEventBean selectExprInsertEventBean;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public SelectExprEvalProcessor(List<SelectClauseExprCompiledSpec> selectionList, InsertIntoDesc insertIntoDesc, boolean isUsingWildcard, StreamTypeService typeService, EventAdapterService eventAdapterService, ValueAddEventService revisionService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.eventAdapterService = eventAdapterService;
        this.isUsingWildcard = isUsingWildcard;
        this.exprEvaluatorContext = exprEvaluatorContext;
        if (selectionList.size() == 0 && !isUsingWildcard) {
            throw new IllegalArgumentException("Empty selection list not supported");
        }
        for (SelectClauseExprCompiledSpec entry : selectionList) {
            if (entry.getAssignedName() != null) continue;
            throw new IllegalArgumentException("Expected name for each expression has not been supplied");
        }
        if (insertIntoDesc != null) {
            SelectExprEvalProcessor.verifyInsertInto(insertIntoDesc, selectionList);
        }
        if (typeService.getStreamNames().length > 1 && isUsingWildcard) {
            this.joinWildcardProcessor = new SelectExprJoinWildcardProcessor(typeService.getStreamNames(), typeService.getEventTypes(), eventAdapterService, null, selectExprEventTypeRegistry, methodResolutionService, exprEvaluatorContext);
        }
        EventType underlyingType = null;
        if (isUsingWildcard) {
            if (this.joinWildcardProcessor != null) {
                underlyingType = this.joinWildcardProcessor.getResultEventType();
            } else {
                underlyingType = typeService.getEventTypes()[0];
                if (underlyingType instanceof WrapperEventType) {
                    this.singleStreamWrapper = true;
                }
            }
        }
        this.init(selectionList, insertIntoDesc, underlyingType, eventAdapterService, typeService, revisionService, selectExprEventTypeRegistry, methodResolutionService);
    }

    private void init(List<SelectClauseExprCompiledSpec> selectionList, InsertIntoDesc insertIntoDesc, EventType eventType, EventAdapterService eventAdapterService, StreamTypeService typeService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService) throws ExprValidationException {
        int i;
        int i2;
        this.expressionNodes = new ExprEvaluator[selectionList.size()];
        Object[] expressionReturnTypes = new Object[selectionList.size()];
        for (i2 = 0; i2 < selectionList.size(); ++i2) {
            ExprNode expr = selectionList.get(i2).getSelectExpression();
            this.expressionNodes[i2] = expr;
            expressionReturnTypes[i2] = expr.getType();
        }
        if (insertIntoDesc != null && !insertIntoDesc.getColumnNames().isEmpty()) {
            this.columnNames = insertIntoDesc.getColumnNames().toArray(new String[insertIntoDesc.getColumnNames().size()]);
        } else {
            this.columnNames = new String[selectionList.size()];
            for (i2 = 0; i2 < selectionList.size(); ++i2) {
                this.columnNames[i2] = selectionList.get(i2).getAssignedName();
            }
        }
        EventType targetType = null;
        if (insertIntoDesc != null) {
            targetType = eventAdapterService.getExistsTypeByName(insertIntoDesc.getEventTypeName());
        }
        for (i = 0; i < selectionList.size(); ++i) {
            ExprEvaluator evaluatorFragment;
            EventPropertyGetter getter;
            FragmentEventType fragmentType;
            if (!(this.expressionNodes[i] instanceof ExprIdentNode)) continue;
            ExprIdentNode identNode = (ExprIdentNode)this.expressionNodes[i];
            String propertyName = identNode.getResolvedPropertyName();
            final int streamNum = identNode.getStreamId();
            EventType eventTypeStream = typeService.getEventTypes()[streamNum];
            if (eventTypeStream instanceof NativeEventType || (fragmentType = eventTypeStream.getFragmentType(propertyName)) == null || fragmentType.isNative()) continue;
            FragmentEventType targetFragment = null;
            if (targetType != null) {
                targetFragment = targetType.getFragmentType(this.columnNames[i]);
            }
            if (targetType != null && fragmentType.getFragmentType().getUnderlyingType() == expressionReturnTypes[i] && (targetFragment == null || targetFragment != null && targetFragment.isNative())) {
                getter = eventTypeStream.getGetter(propertyName);
                this.expressionNodes[i] = evaluatorFragment = new ExprEvaluator(){

                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        EventBean streamEvent = eventsPerStream[streamNum];
                        if (streamEvent == null) {
                            return null;
                        }
                        return getter.get(streamEvent);
                    }
                };
                continue;
            }
            getter = eventTypeStream.getGetter(propertyName);
            this.expressionNodes[i] = evaluatorFragment = new ExprEvaluator(){

                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean streamEvent = eventsPerStream[streamNum];
                    if (streamEvent == null) {
                        return null;
                    }
                    return getter.getFragment(streamEvent);
                }
            };
            expressionReturnTypes[i] = !fragmentType.isIndexed() ? fragmentType.getFragmentType() : new EventType[]{fragmentType.getFragmentType()};
        }
        for (i = 0; i < selectionList.size(); ++i) {
            ExprEvaluator evaluator;
            if (!(this.expressionNodes[i] instanceof ExprStreamUnderlyingNode)) continue;
            ExprStreamUnderlyingNode undNode = (ExprStreamUnderlyingNode)this.expressionNodes[i];
            final int streamNum = undNode.getStreamId();
            EventType eventTypeStream = typeService.getEventTypes()[streamNum];
            this.expressionNodes[i] = evaluator = new ExprEvaluator(){

                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    return eventsPerStream[streamNum];
                }
            };
            expressionReturnTypes[i] = eventTypeStream;
        }
        LinkedHashMap<String, Object> selPropertyTypes = new LinkedHashMap<String, Object>();
        for (int i3 = 0; i3 < this.expressionNodes.length; ++i3) {
            Object expressionReturnType = expressionReturnTypes[i3];
            selPropertyTypes.put(this.columnNames[i3], expressionReturnType);
        }
        if (insertIntoDesc != null) {
            try {
                this.vaeProcessor = valueAddEventService.getValueAddProcessor(insertIntoDesc.getEventTypeName());
                if (this.isUsingWildcard) {
                    if (this.vaeProcessor != null) {
                        this.resultEventType = this.vaeProcessor.getValueAddEventType();
                        this.isRevisionEvent = true;
                        this.vaeProcessor.validateEventType(eventType);
                    } else {
                        EventType existingType = eventAdapterService.getExistsTypeByName(insertIntoDesc.getEventTypeName());
                        if (existingType != null) {
                            this.selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(eventAdapterService, existingType);
                        }
                        if (existingType != null && this.selectExprInsertEventBean != null) {
                            this.selectExprInsertEventBean.initialize(this.isUsingWildcard, typeService, this.expressionNodes, this.columnNames, expressionReturnTypes, methodResolutionService, eventAdapterService);
                            this.resultEventType = existingType;
                            this.isPopulateUnderlying = true;
                        } else {
                            this.resultEventType = eventAdapterService.addWrapperType(insertIntoDesc.getEventTypeName(), eventType, selPropertyTypes, false, true);
                        }
                    }
                } else {
                    EventType existingType;
                    this.resultEventType = null;
                    if (this.columnNames.length == 1 && insertIntoDesc.getColumnNames().size() == 0 && (existingType = eventAdapterService.getExistsTypeByName(insertIntoDesc.getEventTypeName())) != null) {
                        WrapperEventType wrapperType;
                        Object columnOneType = expressionReturnTypes[0];
                        if (existingType instanceof WrapperEventType && (wrapperType = (WrapperEventType)existingType).getUnderlyingEventType().getUnderlyingType() == columnOneType) {
                            this.singleColumnCoercion = true;
                            this.resultEventType = existingType;
                        }
                    }
                    if (this.resultEventType == null) {
                        if (this.vaeProcessor != null) {
                            this.resultEventType = eventAdapterService.createAnonymousMapType(selPropertyTypes);
                        } else {
                            existingType = eventAdapterService.getExistsTypeByName(insertIntoDesc.getEventTypeName());
                            if (existingType != null) {
                                this.selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(eventAdapterService, existingType);
                            }
                            if (existingType != null && this.selectExprInsertEventBean != null) {
                                this.selectExprInsertEventBean.initialize(this.isUsingWildcard, typeService, this.expressionNodes, this.columnNames, expressionReturnTypes, methodResolutionService, eventAdapterService);
                                this.resultEventType = existingType;
                                this.isPopulateUnderlying = true;
                            } else {
                                this.resultEventType = eventAdapterService.addNestableMapType(insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, true);
                            }
                        }
                    }
                    if (this.vaeProcessor != null) {
                        this.vaeProcessor.validateEventType(this.resultEventType);
                        this.vaeInnerEventType = this.resultEventType;
                        this.resultEventType = this.vaeProcessor.getValueAddEventType();
                        this.isRevisionEvent = true;
                    }
                }
                selectExprEventTypeRegistry.add(this.resultEventType);
            }
            catch (EventAdapterException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
        } else {
            this.resultEventType = this.isUsingWildcard ? eventAdapterService.createAnonymousWrapperType(eventType, selPropertyTypes) : eventAdapterService.createAnonymousMapType(selPropertyTypes);
        }
        boolean bl = this.isEmptyExpressionNodes = this.expressionNodes.length == 0;
        if (log.isDebugEnabled()) {
            log.debug(".init resultEventType=" + this.resultEventType);
        }
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        HashMap<String, Object> props;
        if (this.isPopulateUnderlying) {
            return this.selectExprInsertEventBean.manufacture(eventsPerStream, isNewData, this.exprEvaluatorContext);
        }
        if (this.isEmptyExpressionNodes) {
            props = Collections.EMPTY_MAP;
        } else {
            props = new HashMap<String, Object>();
            for (int i = 0; i < this.expressionNodes.length; ++i) {
                Object evalResult = this.expressionNodes[i].evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext);
                props.put(this.columnNames[i], evalResult);
            }
        }
        if (this.isUsingWildcard) {
            DecoratingEventBean wrapper;
            if (this.singleStreamWrapper && (wrapper = (DecoratingEventBean)((Object)eventsPerStream[0])) != null) {
                Map<String, Object> map = wrapper.getDecoratingProperties();
                if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                    log.debug(".process additional properties=" + map);
                }
                if (this.isEmptyExpressionNodes && !map.isEmpty()) {
                    props = new HashMap<String, Object>(map);
                } else {
                    props.putAll(map);
                }
            }
            EventBean event = this.joinWildcardProcessor != null ? this.joinWildcardProcessor.process(eventsPerStream, isNewData, isSynthesize) : eventsPerStream[0];
            if (this.isRevisionEvent) {
                return this.vaeProcessor.getValueAddEventBean(event);
            }
            return this.eventAdapterService.adaptorForTypedWrapper(event, props, this.resultEventType);
        }
        if (this.singleColumnCoercion) {
            Object result = props.get(this.columnNames[0]);
            EventBean wrappedEvent = result instanceof Map ? this.eventAdapterService.adaptorForTypedMap((Map)result, this.resultEventType) : this.eventAdapterService.adapterForBean(result);
            props.clear();
            if (!this.isRevisionEvent) {
                return this.eventAdapterService.adaptorForTypedWrapper(wrappedEvent, props, this.resultEventType);
            }
            return this.vaeProcessor.getValueAddEventBean(this.eventAdapterService.adaptorForTypedWrapper(wrappedEvent, props, this.vaeInnerEventType));
        }
        if (!this.isRevisionEvent) {
            return this.eventAdapterService.adaptorForTypedMap(props, this.resultEventType);
        }
        return this.vaeProcessor.getValueAddEventBean(this.eventAdapterService.adaptorForTypedMap(props, this.vaeInnerEventType));
    }

    @Override
    public EventType getResultEventType() {
        return this.resultEventType;
    }

    private static void verifyInsertInto(InsertIntoDesc insertIntoDesc, List<SelectClauseExprCompiledSpec> selectionList) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (String element : insertIntoDesc.getColumnNames()) {
            if (names.contains(element)) {
                throw new ExprValidationException("Property name '" + element + "' appears more then once in insert-into clause");
            }
            names.add(element);
        }
        if (!insertIntoDesc.getColumnNames().isEmpty() && insertIntoDesc.getColumnNames().size() != selectionList.size()) {
            throw new ExprValidationException("Number of supplied values in the select clause does not match insert-into clause");
        }
    }
}

