/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.event.DecoratingEventBean;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprEvalProcessorStreams
implements SelectExprProcessor {
    private static final Log log = LogFactory.getLog(SelectExprEvalProcessorStreams.class);
    private final EventAdapterService eventAdapterService;
    private final List<SelectClauseStreamCompiledSpec> namedStreams;
    private final List<SelectClauseStreamCompiledSpec> unnamedStreams;
    private boolean singleStreamWrapper;
    private boolean isUsingWildcard;
    private ExprNode[] expressionNodes;
    private String[] columnNames;
    private EventType resultEventType;
    private EventType underlyingEventType;
    private int underlyingStreamNumber;
    private boolean underlyingIsFragmentEvent;
    private EventPropertyGetter underlyingPropertyEventGetter;
    private ExprEvaluatorContext exprEvaluatorContext;

    public SelectExprEvalProcessorStreams(List<SelectClauseExprCompiledSpec> selectionList, List<SelectClauseStreamCompiledSpec> selectedStreams, InsertIntoDesc insertIntoDesc, boolean isUsingWildcard, StreamTypeService typeService, EventAdapterService eventAdapterService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.eventAdapterService = eventAdapterService;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.isUsingWildcard = isUsingWildcard;
        this.unnamedStreams = new ArrayList<SelectClauseStreamCompiledSpec>();
        this.namedStreams = new ArrayList<SelectClauseStreamCompiledSpec>();
        for (SelectClauseStreamCompiledSpec spec : selectedStreams) {
            if (spec.getOptionalName() == null) {
                this.unnamedStreams.add(spec);
                continue;
            }
            this.namedStreams.add(spec);
            if (!spec.isProperty()) continue;
            throw new ExprValidationException("The property wildcard syntax must be used without column name");
        }
        if (insertIntoDesc != null) {
            SelectExprEvalProcessorStreams.verifyInsertInto(insertIntoDesc, selectionList, this.namedStreams);
        }
        if (this.unnamedStreams.size() > 1) {
            throw new ExprValidationException("A column name must be supplied for all but one stream if multiple streams are selected via the stream.* notation");
        }
        if (isUsingWildcard || !this.unnamedStreams.isEmpty()) {
            if (!this.unnamedStreams.isEmpty()) {
                this.underlyingStreamNumber = this.unnamedStreams.get(0).getStreamNumber();
                if (this.unnamedStreams.get(0).isFragmentEvent()) {
                    EventType compositeMap = typeService.getEventTypes()[this.underlyingStreamNumber];
                    FragmentEventType fragment = compositeMap.getFragmentType(this.unnamedStreams.get(0).getStreamName());
                    this.underlyingEventType = fragment.getFragmentType();
                    this.underlyingIsFragmentEvent = true;
                } else if (this.unnamedStreams.get(0).isProperty()) {
                    String propertyName = this.unnamedStreams.get(0).getStreamName();
                    Class propertyType = this.unnamedStreams.get(0).getPropertyType();
                    int streamNumber = this.unnamedStreams.get(0).getStreamNumber();
                    if (JavaClassHelper.isJavaBuiltinDataType(this.unnamedStreams.get(0).getPropertyType())) {
                        throw new ExprValidationException("The property wildcard syntax cannot be used on built-in types as returned by property '" + propertyName + "'");
                    }
                    this.underlyingEventType = eventAdapterService.addBeanType(propertyType.getName(), propertyType, false);
                    selectExprEventTypeRegistry.add(this.underlyingEventType);
                    this.underlyingPropertyEventGetter = typeService.getEventTypes()[streamNumber].getGetter(propertyName);
                    if (this.underlyingPropertyEventGetter == null) {
                        throw new ExprValidationException("Unexpected error resolving property getter for property " + propertyName);
                    }
                } else {
                    this.underlyingEventType = typeService.getEventTypes()[this.underlyingStreamNumber];
                }
            } else if (typeService.getEventTypes().length == 1) {
                this.underlyingEventType = typeService.getEventTypes()[0];
                if (this.underlyingEventType instanceof WrapperEventType) {
                    this.singleStreamWrapper = true;
                }
            } else {
                this.underlyingEventType = null;
            }
        }
        this.init(selectionList, this.namedStreams, insertIntoDesc, eventAdapterService, typeService, selectExprEventTypeRegistry);
    }

    private void init(List<SelectClauseExprCompiledSpec> selectionList, List<SelectClauseStreamCompiledSpec> namedStreams, InsertIntoDesc insertIntoDesc, EventAdapterService eventAdapterService, StreamTypeService typeService, SelectExprEventTypeRegistry selectExprEventTypeRegistry) throws ExprValidationException {
        int count;
        this.expressionNodes = new ExprNode[selectionList.size()];
        for (int i = 0; i < selectionList.size(); ++i) {
            this.expressionNodes[i] = selectionList.get(i).getSelectExpression();
        }
        if (insertIntoDesc != null && !insertIntoDesc.getColumnNames().isEmpty()) {
            this.columnNames = insertIntoDesc.getColumnNames().toArray(new String[insertIntoDesc.getColumnNames().size()]);
        } else {
            int numStreamColumnsJoin = 0;
            if (this.isUsingWildcard && typeService.getEventTypes().length > 1) {
                numStreamColumnsJoin = typeService.getEventTypes().length;
            }
            this.columnNames = new String[selectionList.size() + namedStreams.size() + numStreamColumnsJoin];
            count = 0;
            for (SelectClauseExprCompiledSpec selectClauseExprCompiledSpec : selectionList) {
                this.columnNames[count] = selectClauseExprCompiledSpec.getAssignedName();
                ++count;
            }
            for (SelectClauseStreamCompiledSpec selectClauseStreamCompiledSpec : namedStreams) {
                this.columnNames[count] = selectClauseStreamCompiledSpec.getOptionalName();
                ++count;
            }
            if (this.isUsingWildcard && typeService.getEventTypes().length > 1) {
                Object[] arr$ = typeService.getStreamNames();
                int n = arr$.length;
                for (int i$ = 0; i$ < n; ++i$) {
                    Object streamName;
                    this.columnNames[count] = streamName = arr$[i$];
                    ++count;
                }
            }
        }
        LinkedHashMap<String, Object> selPropertyTypes = new LinkedHashMap<String, Object>();
        count = 0;
        for (ExprNode expressionNode : this.expressionNodes) {
            Class expressionReturnType = expressionNode.getType();
            selPropertyTypes.put(this.columnNames[count], expressionReturnType);
            ++count;
        }
        for (SelectClauseStreamCompiledSpec selectClauseStreamCompiledSpec : namedStreams) {
            EventType eventTypeStream = typeService.getEventTypes()[selectClauseStreamCompiledSpec.getStreamNumber()];
            selPropertyTypes.put(this.columnNames[count], eventTypeStream);
            ++count;
        }
        if (this.isUsingWildcard && typeService.getEventTypes().length > 1) {
            for (int i = 0; i < typeService.getEventTypes().length; ++i) {
                EventType eventType = typeService.getEventTypes()[i];
                selPropertyTypes.put(this.columnNames[count], eventType);
                ++count;
            }
        }
        if (insertIntoDesc != null) {
            try {
                this.resultEventType = this.underlyingEventType != null ? eventAdapterService.addWrapperType(insertIntoDesc.getEventTypeName(), this.underlyingEventType, selPropertyTypes, false, true) : eventAdapterService.addNestableMapType(insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, true);
                selectExprEventTypeRegistry.add(this.resultEventType);
            }
            catch (EventAdapterException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
        } else {
            this.resultEventType = this.underlyingEventType != null ? eventAdapterService.createAnonymousWrapperType(this.underlyingEventType, selPropertyTypes) : eventAdapterService.createAnonymousMapType(selPropertyTypes);
        }
        if (log.isDebugEnabled()) {
            log.debug(".init resultEventType=" + this.resultEventType);
        }
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        int count = 0;
        for (ExprNode expressionNode : this.expressionNodes) {
            Object evalResult = expressionNode.evaluate(eventsPerStream, isNewData, this.exprEvaluatorContext);
            props.put(this.columnNames[count], evalResult);
            ++count;
        }
        for (SelectClauseStreamCompiledSpec element : this.namedStreams) {
            EventBean event = eventsPerStream[element.getStreamNumber()];
            props.put(this.columnNames[count], event);
            ++count;
        }
        if (this.isUsingWildcard && eventsPerStream.length > 1) {
            for (EventBean anEventsPerStream : eventsPerStream) {
                props.put(this.columnNames[count], anEventsPerStream);
                ++count;
            }
        }
        if (this.underlyingEventType != null) {
            DecoratingEventBean wrapper;
            if (this.singleStreamWrapper && (wrapper = (DecoratingEventBean)((Object)eventsPerStream[0])) != null) {
                Map<String, Object> map = wrapper.getDecoratingProperties();
                if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                    log.debug(".process additional properties=" + map);
                }
                props.putAll(map);
            }
            EventBean event = null;
            if (this.underlyingIsFragmentEvent) {
                EventBean eventBean = eventsPerStream[this.underlyingStreamNumber];
                event = (EventBean)eventBean.getFragment(this.unnamedStreams.get(0).getStreamName());
            } else if (this.underlyingPropertyEventGetter != null) {
                Object value = this.underlyingPropertyEventGetter.get(eventsPerStream[this.underlyingStreamNumber]);
                if (value != null) {
                    event = this.eventAdapterService.adapterForBean(value);
                }
            } else {
                event = eventsPerStream[this.underlyingStreamNumber];
            }
            return this.eventAdapterService.adaptorForTypedWrapper(event, props, this.resultEventType);
        }
        return this.eventAdapterService.adaptorForTypedMap(props, this.resultEventType);
    }

    @Override
    public EventType getResultEventType() {
        return this.resultEventType;
    }

    private static void verifyInsertInto(InsertIntoDesc insertIntoDesc, List<SelectClauseExprCompiledSpec> selectionList, List<SelectClauseStreamCompiledSpec> namedStreams) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (String element : insertIntoDesc.getColumnNames()) {
            if (names.contains(element)) {
                throw new ExprValidationException("Property name '" + element + "' appears more then once in insert-into clause");
            }
            names.add(element);
        }
        if (!insertIntoDesc.getColumnNames().isEmpty() && insertIntoDesc.getColumnNames().size() != selectionList.size() + namedStreams.size()) {
            throw new ExprValidationException("Number of supplied values in the select clause does not match insert-into clause");
        }
    }
}

