/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprInsertEventBean {
    private static Log log = LogFactory.getLog(SelectExprInsertEventBean.class);
    private EventType eventType;
    private Set<WriteablePropertyDescriptor> writables;
    private EventBeanManufacturer eventManufacturer;
    private WriteablePropertyDescriptor[] writableProperties;
    private ExprEvaluator[] expressionNodes;
    private TypeWidener[] wideners;

    public static SelectExprInsertEventBean getInsertUnderlying(EventAdapterService eventAdapterService, EventType eventType) {
        Set<WriteablePropertyDescriptor> writableProps = eventAdapterService.getWriteableProperties(eventType);
        if (writableProps == null) {
            return null;
        }
        return new SelectExprInsertEventBean(eventType, writableProps);
    }

    private SelectExprInsertEventBean(EventType eventType, Set<WriteablePropertyDescriptor> writables) {
        this.eventType = eventType;
        this.writables = writables;
    }

    public void initializeJoinWildcard(String[] streamNames, EventType[] streamTypes, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService) throws ExprValidationException {
        ArrayList<WriteablePropertyDescriptor> writablePropertiesList = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<1> evaluatorsList = new ArrayList<1>();
        ArrayList<TypeWidener> widenersList = new ArrayList<TypeWidener>();
        int i = 0;
        while (i < streamNames.length) {
            WriteablePropertyDescriptor selectedWritable = null;
            TypeWidener widener = null;
            for (WriteablePropertyDescriptor desc : this.writables) {
                if (!desc.getPropertyName().equals(streamNames[i])) continue;
                widener = TypeWidenerFactory.getCheckPropertyAssignType(streamNames[i], streamTypes[i].getUnderlyingType(), desc.getType(), desc.getPropertyName());
                selectedWritable = desc;
                break;
            }
            if (selectedWritable == null) {
                String message = "Stream underlying object for stream '" + streamNames[i] + "' could not be assigned to any of the properties of the underlying type (missing column names, event property or setter method?)";
                throw new ExprValidationException(message);
            }
            final int streamNum = i++;
            ExprEvaluator evaluator = new ExprEvaluator(){

                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean event = eventsPerStream[streamNum];
                    if (event != null) {
                        return event.getUnderlying();
                    }
                    return null;
                }
            };
            writablePropertiesList.add(selectedWritable);
            evaluatorsList.add(evaluator);
            widenersList.add(widener);
        }
        this.writableProperties = writablePropertiesList.toArray(new WriteablePropertyDescriptor[writablePropertiesList.size()]);
        this.expressionNodes = evaluatorsList.toArray(new ExprEvaluator[evaluatorsList.size()]);
        this.wideners = widenersList.toArray(new TypeWidener[widenersList.size()]);
        try {
            this.eventManufacturer = eventAdapterService.getManufacturer(this.eventType, this.writableProperties, methodResolutionService);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
    }

    public void initialize(boolean isUsingWildcard, StreamTypeService typeService, ExprEvaluator[] expressionNodes, String[] columnNames, Object[] expressionReturnTypes, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService) throws ExprValidationException {
        ArrayList<WriteablePropertyDescriptor> writablePropertiesList = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<ExprEvaluator> evaluatorsList = new ArrayList<ExprEvaluator>();
        ArrayList<TypeWidener> widenersList = new ArrayList<TypeWidener>();
        for (int i = 0; i < columnNames.length; ++i) {
            WriteablePropertyDescriptor selectedWritable = null;
            TypeWidener widener = null;
            ExprEvaluator evaluator = expressionNodes[i];
            for (WriteablePropertyDescriptor desc : this.writables) {
                if (!desc.getPropertyName().equals(columnNames[i])) continue;
                Object columnType = expressionReturnTypes[i];
                if (columnType == null) {
                    TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], null, desc.getType(), desc.getPropertyName());
                } else if (columnType instanceof EventType) {
                    EventType columnEventType = (EventType)columnType;
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], columnEventType.getUnderlyingType(), desc.getType(), desc.getPropertyName());
                    int streamNum = 0;
                    for (int j = 0; j < typeService.getEventTypes().length; ++j) {
                        if (typeService.getEventTypes()[j] != columnEventType) continue;
                        streamNum = j;
                        break;
                    }
                    final int streamNumEval = streamNum;
                    evaluator = new ExprEvaluator(){

                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            EventBean event = eventsPerStream[streamNumEval];
                            if (event != null) {
                                return event.getUnderlying();
                            }
                            return null;
                        }
                    };
                } else {
                    if (!(columnType instanceof Class)) {
                        String message = "Invalid assignment of column '" + columnNames[i] + "' of type '" + columnType + "' to event property '" + desc.getPropertyName() + "' typed as '" + desc.getType().getName() + "', column and parameter types mismatch";
                        throw new ExprValidationException(message);
                    }
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], (Class)columnType, desc.getType(), desc.getPropertyName());
                }
                selectedWritable = desc;
                break;
            }
            if (selectedWritable == null) {
                String message = "Column '" + columnNames[i] + "' could not be assigned to any of the properties of the underlying type (missing column names, event property or setter method?)";
                throw new ExprValidationException(message);
            }
            writablePropertiesList.add(selectedWritable);
            evaluatorsList.add(evaluator);
            widenersList.add(widener);
        }
        if (isUsingWildcard) {
            EventType sourceType = typeService.getEventTypes()[0];
            for (EventPropertyDescriptor eventPropDescriptor : sourceType.getPropertyDescriptors()) {
                if (eventPropDescriptor.isRequiresIndex() || eventPropDescriptor.isRequiresMapkey()) continue;
                WriteablePropertyDescriptor selectedWritable = null;
                TypeWidener widener = null;
                ExprEvaluator evaluator = null;
                for (WriteablePropertyDescriptor writableDesc : this.writables) {
                    if (!writableDesc.getPropertyName().equals(eventPropDescriptor.getPropertyName())) continue;
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(eventPropDescriptor.getPropertyName(), eventPropDescriptor.getPropertyType(), writableDesc.getType(), writableDesc.getPropertyName());
                    selectedWritable = writableDesc;
                    final String propertyName = eventPropDescriptor.getPropertyName();
                    evaluator = new ExprEvaluator(){

                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            EventBean event = eventsPerStream[0];
                            if (event != null) {
                                return event.get(propertyName);
                            }
                            return null;
                        }
                    };
                    break;
                }
                if (selectedWritable == null) {
                    String message = "Event property '" + eventPropDescriptor.getPropertyName() + "' could not be assigned to any of the properties of the underlying type (missing column names, event property or setter method?)";
                    throw new ExprValidationException(message);
                }
                writablePropertiesList.add(selectedWritable);
                evaluatorsList.add(evaluator);
                widenersList.add(widener);
            }
        }
        this.writableProperties = writablePropertiesList.toArray(new WriteablePropertyDescriptor[writablePropertiesList.size()]);
        this.expressionNodes = evaluatorsList.toArray(new ExprEvaluator[evaluatorsList.size()]);
        this.wideners = widenersList.toArray(new TypeWidener[widenersList.size()]);
        try {
            this.eventManufacturer = eventAdapterService.getManufacturer(this.eventType, this.writableProperties, methodResolutionService);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
    }

    public EventBean manufacture(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] values = new Object[this.writableProperties.length];
        for (int i = 0; i < this.writableProperties.length; ++i) {
            Object evalResult = this.expressionNodes[i].evaluate(eventsPerStream, newData, exprEvaluatorContext);
            if (evalResult != null && this.wideners[i] != null) {
                evalResult = this.wideners[i].widen(evalResult);
            }
            values[i] = evalResult;
        }
        return this.eventManufacturer.make(values);
    }
}

