/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.core.BindProcessor;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEvalProcessor;
import com.espertech.esper.epl.core.SelectExprEvalProcessorStreams;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprResultProcessor;
import com.espertech.esper.epl.core.SelectExprWildcardProcessor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprProcessorFactory {
    private static final Log log = LogFactory.getLog(SelectExprProcessorFactory.class);

    public static SelectExprProcessor getProcessor(List<SelectClauseElementCompiled> selectionList, boolean isUsingWildcard, InsertIntoDesc insertIntoDesc, StreamTypeService typeService, EventAdapterService eventAdapterService, StatementResultService statementResultService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        SelectExprProcessor synthetic = SelectExprProcessorFactory.getProcessorInternal(selectionList, isUsingWildcard, insertIntoDesc, typeService, eventAdapterService, valueAddEventService, selectExprEventTypeRegistry, methodResolutionService, exprEvaluatorContext);
        if (statementResultService != null) {
            BindProcessor bindProcessor = new BindProcessor(selectionList, typeService.getEventTypes(), typeService.getStreamNames());
            statementResultService.setSelectClause(bindProcessor.getExpressionTypes(), bindProcessor.getColumnNamesAssigned());
            return new SelectExprResultProcessor(statementResultService, synthetic, bindProcessor, exprEvaluatorContext);
        }
        return synthetic;
    }

    private static SelectExprProcessor getProcessorInternal(List<SelectClauseElementCompiled> selectionList, boolean isUsingWildcard, InsertIntoDesc insertIntoDesc, StreamTypeService typeService, EventAdapterService eventAdapterService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (isUsingWildcard && insertIntoDesc != null && !insertIntoDesc.getColumnNames().isEmpty()) {
            throw new ExprValidationException("Wildcard not allowed when insert-into specifies column order");
        }
        if (SelectExprProcessorFactory.isWildcardsOnly(selectionList)) {
            if (typeService.getStreamNames().length > 1) {
                log.debug(".getProcessor Using SelectExprJoinWildcardProcessor");
                return new SelectExprJoinWildcardProcessor(typeService.getStreamNames(), typeService.getEventTypes(), eventAdapterService, insertIntoDesc, selectExprEventTypeRegistry, methodResolutionService, exprEvaluatorContext);
            }
            if (insertIntoDesc == null) {
                log.debug(".getProcessor Using wildcard processor");
                return new SelectExprWildcardProcessor(typeService.getEventTypes()[0]);
            }
        }
        SelectExprProcessorFactory.verifyNameUniqueness(selectionList);
        log.debug(".getProcessor Using SelectExprEvalProcessor");
        List<SelectClauseExprCompiledSpec> expressionList = SelectExprProcessorFactory.getExpressions(selectionList);
        List<SelectClauseStreamCompiledSpec> streamWildcards = SelectExprProcessorFactory.getStreamWildcards(selectionList);
        if (streamWildcards.size() == 0) {
            return new SelectExprEvalProcessor(expressionList, insertIntoDesc, isUsingWildcard, typeService, eventAdapterService, valueAddEventService, selectExprEventTypeRegistry, methodResolutionService, exprEvaluatorContext);
        }
        return new SelectExprEvalProcessorStreams(expressionList, streamWildcards, insertIntoDesc, isUsingWildcard, typeService, eventAdapterService, selectExprEventTypeRegistry, exprEvaluatorContext);
    }

    protected static void verifyNameUniqueness(List<SelectClauseElementCompiled> selectionList) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (SelectClauseElementCompiled element : selectionList) {
            SelectClauseStreamCompiledSpec stream;
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
                if (names.contains(expr.getAssignedName())) {
                    throw new ExprValidationException("Column name '" + expr.getAssignedName() + "' appears more then once in select clause");
                }
                names.add(expr.getAssignedName());
                continue;
            }
            if (!(element instanceof SelectClauseStreamCompiledSpec) || (stream = (SelectClauseStreamCompiledSpec)element).getOptionalName() == null) continue;
            if (names.contains(stream.getOptionalName())) {
                throw new ExprValidationException("Column name '" + stream.getOptionalName() + "' appears more then once in select clause");
            }
            names.add(stream.getOptionalName());
        }
    }

    private static boolean isWildcardsOnly(List<SelectClauseElementCompiled> elements) {
        for (SelectClauseElementCompiled element : elements) {
            if (element instanceof SelectClauseElementWildcard) continue;
            return false;
        }
        return true;
    }

    private static List<SelectClauseExprCompiledSpec> getExpressions(List<SelectClauseElementCompiled> elements) {
        ArrayList<SelectClauseExprCompiledSpec> result = new ArrayList<SelectClauseExprCompiledSpec>();
        for (SelectClauseElementCompiled element : elements) {
            if (!(element instanceof SelectClauseExprCompiledSpec)) continue;
            result.add((SelectClauseExprCompiledSpec)element);
        }
        return result;
    }

    private static List<SelectClauseStreamCompiledSpec> getStreamWildcards(List<SelectClauseElementCompiled> elements) {
        ArrayList<SelectClauseStreamCompiledSpec> result = new ArrayList<SelectClauseStreamCompiledSpec>();
        for (SelectClauseElementCompiled element : elements) {
            if (!(element instanceof SelectClauseStreamCompiledSpec)) continue;
            result.add((SelectClauseStreamCompiledSpec)element);
        }
        return result;
    }
}

