/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;

public class ViewResourceDelegateImpl
implements ViewResourceDelegate {
    private StatementContext statementContext;
    private ViewFactoryChain[] viewFactories;

    public ViewResourceDelegateImpl(ViewFactoryChain[] viewFactories, StatementContext statementContext) {
        this.viewFactories = viewFactories;
        this.statementContext = statementContext;
    }

    public boolean requestCapability(int streamNumber, ViewCapability requestedCabability, ViewResourceCallback resourceCallback) throws ExprValidationException {
        ViewFactoryChain factories = this.viewFactories[streamNumber];
        if (!requestedCabability.inspect(streamNumber, factories.getViewFactoryChain(), this.statementContext)) {
            return false;
        }
        boolean found = false;
        for (ViewFactory factory : factories.getViewFactoryChain()) {
            if (!factory.canProvideCapability(requestedCabability)) continue;
            factory.setProvideCapability(requestedCabability, resourceCallback);
            found = true;
            if (requestedCabability.appliesToChildViews()) continue;
            return true;
        }
        if (requestedCabability.appliesToChildViews()) {
            return found;
        }
        return !requestedCabability.requiresChildViews() && factories.getViewFactoryChain().isEmpty();
    }
}

