/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.ConfigurationDBRef;
import com.espertech.esper.epl.db.DatabaseConfigException;
import com.espertech.esper.epl.db.DatabaseConnectionFactory;
import com.espertech.esper.epl.db.DatabaseDMConnFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DatabaseDSConnFactory
implements DatabaseConnectionFactory {
    private final ConfigurationDBRef.DataSourceConnection dsConfig;
    private final ConfigurationDBRef.ConnectionSettings connectionSettings;
    private DataSource dataSource;

    public DatabaseDSConnFactory(ConfigurationDBRef.DataSourceConnection dsConfig, ConfigurationDBRef.ConnectionSettings connectionSettings) {
        this.dsConfig = dsConfig;
        this.connectionSettings = connectionSettings;
    }

    public Connection getConnection() throws DatabaseConfigException {
        Connection connection;
        if (this.dataSource == null) {
            DataSource ds;
            InitialContext ctx;
            Properties envProps = this.dsConfig.getEnvProperties();
            if (envProps == null) {
                envProps = new Properties();
            }
            try {
                ctx = !envProps.isEmpty() ? new InitialContext(envProps) : new InitialContext();
            }
            catch (NamingException ex) {
                throw new DatabaseConfigException("Error instantiating initial context", ex);
            }
            String lookupName = this.dsConfig.getContextLookupName();
            try {
                ds = (DataSource)ctx.lookup(lookupName);
            }
            catch (NamingException ex) {
                throw new DatabaseConfigException("Error looking up data source in context using name '" + lookupName + '\'', ex);
            }
            if (ds == null) {
                throw new DatabaseConfigException("Null data source obtained through context using name '" + lookupName + '\'');
            }
            this.dataSource = ds;
        }
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            String detail = "SQLException: " + ex.getMessage() + " SQLState: " + ex.getSQLState() + " VendorError: " + ex.getErrorCode();
            throw new DatabaseConfigException("Error obtaining database connection using datasource with detail " + detail, ex);
        }
        DatabaseDMConnFactory.setConnectionOptions(connection, this.connectionSettings);
        return connection;
    }
}

