/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.util.LinkedList;
import java.util.List;

public class ExprCaseNode
extends ExprNode {
    private final boolean isCase2;
    private List<UniformPair<ExprNode>> whenThenNodeList;
    private ExprNode optionalCompareExprNode;
    private ExprNode optionalElseExprNode;
    private Class resultType;
    private boolean isNumericResult;
    private boolean mustCoerce;
    private SimpleNumberCoercer coercer;
    private static final long serialVersionUID = 792538321520346459L;

    public ExprCaseNode(boolean isCase2) {
        this.isCase2 = isCase2;
    }

    public boolean isCase2() {
        return this.isCase2;
    }

    public void validate(StreamTypeService streamTypeService_, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.isCase2) {
            this.validateCaseTwo();
        } else {
            this.validateCaseOne();
        }
        LinkedList<Class> childTypes = new LinkedList<Class>();
        for (UniformPair<ExprNode> pair : this.whenThenNodeList) {
            childTypes.add(pair.getSecond().getType());
        }
        if (this.optionalElseExprNode != null) {
            childTypes.add(this.optionalElseExprNode.getType());
        }
        try {
            this.resultType = JavaClassHelper.getCommonCoercionType(childTypes.toArray(new Class[childTypes.size()]));
            if (JavaClassHelper.isNumeric(this.resultType)) {
                this.isNumericResult = true;
            }
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return this.resultType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (!this.isCase2) {
            return this.evaluateCaseSyntax1(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return this.evaluateCaseSyntax2(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprCaseNode)) {
            return false;
        }
        ExprCaseNode otherExprCaseNode = (ExprCaseNode)node_;
        return this.isCase2 == otherExprCaseNode.isCase2;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("case");
        if (this.isCase2) {
            buffer.append(' ');
            buffer.append(this.getChildNodes().get(0).toExpressionString());
        }
        for (UniformPair<ExprNode> p : this.whenThenNodeList) {
            buffer.append(" when ");
            buffer.append(p.getFirst().toExpressionString());
            buffer.append(" then ");
            buffer.append(p.getSecond().toExpressionString());
        }
        if (this.optionalElseExprNode != null) {
            buffer.append(" else ");
            buffer.append(this.optionalElseExprNode.toExpressionString());
        }
        buffer.append(" end");
        return buffer.toString();
    }

    private void validateCaseOne() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes().toArray(new ExprNode[this.getChildNodes().size()]);
        if (children.length < 2) {
            throw new ExprValidationException("Case node must have at least 2 child nodes");
        }
        this.whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = children.length >> 1;
        for (int i = 0; i < numWhenThen; ++i) {
            ExprNode whenExpr = children[i << 1];
            ExprNode thenExpr = children[(i << 1) + 1];
            if (whenExpr.getType() != Boolean.class) {
                throw new ExprValidationException("Case node 'when' expressions must return a boolean value");
            }
            this.whenThenNodeList.add(new UniformPair<ExprNode>(whenExpr, thenExpr));
        }
        if (children.length % 2 != 0) {
            this.optionalElseExprNode = children[children.length - 1];
        }
    }

    private void validateCaseTwo() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes().toArray(new ExprNode[this.getChildNodes().size()]);
        if (children.length < 3) {
            throw new ExprValidationException("Case node must have at least 3 child nodes");
        }
        this.optionalCompareExprNode = children[0];
        this.whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = (children.length - 1) / 2;
        for (int i = 0; i < numWhenThen; ++i) {
            this.whenThenNodeList.add(new UniformPair<ExprNode>(children[i * 2 + 1], children[i * 2 + 2]));
        }
        if (numWhenThen * 2 + 1 < children.length) {
            this.optionalElseExprNode = children[children.length - 1];
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        comparedTypes.add(this.optionalCompareExprNode.getType());
        for (UniformPair<ExprNode> pair : this.whenThenNodeList) {
            comparedTypes.add(pair.getFirst().getType());
        }
        try {
            Class coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
            if (JavaClassHelper.isNumeric(coercionType)) {
                this.mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == coercionType) continue;
                    this.mustCoerce = true;
                }
                if (this.mustCoerce) {
                    this.coercer = SimpleNumberCoercerFactory.getCoercer(null, coercionType);
                }
            }
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
    }

    private Object evaluateCaseSyntax1(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprNode> p : this.whenThenNodeList) {
            Boolean whenResult = (Boolean)p.getFirst().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (whenResult == null || !whenResult.booleanValue()) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.resultType && this.isNumericResult) {
            return JavaClassHelper.coerceBoxed((Number)caseResult, this.resultType);
        }
        return caseResult;
    }

    private Object evaluateCaseSyntax2(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object checkResult = this.optionalCompareExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprNode> p : this.whenThenNodeList) {
            Object whenResult = p.getFirst().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (!this.compare(checkResult, whenResult)) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.resultType && this.isNumericResult) {
            return JavaClassHelper.coerceBoxed((Number)caseResult, this.resultType);
        }
        return caseResult;
    }

    private boolean compare(Object leftResult, Object rightResult) {
        if (leftResult == null) {
            return rightResult == null;
        }
        if (rightResult == null) {
            return false;
        }
        if (!this.mustCoerce) {
            return leftResult.equals(rightResult);
        }
        Number left = this.coercer.coerceBoxed((Number)leftResult);
        Number right = this.coercer.coerceBoxed((Number)rightResult);
        return left.equals(right);
    }
}

