/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;

public class ExprConstantNode
extends ExprNode {
    private Object value;
    private final Class clazz;
    private static final long serialVersionUID = 3154169410675962539L;

    public ExprConstantNode(Object value) {
        this.value = value;
        this.clazz = value == null ? null : value.getClass();
    }

    public ExprConstantNode(Object value, Class valueType) {
        this.value = value;
        this.clazz = value == null ? valueType : value.getClass();
    }

    public ExprConstantNode(Class clazz) {
        this.clazz = clazz;
        this.value = null;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
    }

    public boolean isConstantResult() {
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Class getType() {
        return this.clazz;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.value;
    }

    public String toExpressionString() {
        if (this.value instanceof String) {
            return "\"" + this.value + '\"';
        }
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprConstantNode)) {
            return false;
        }
        ExprConstantNode other = (ExprConstantNode)node;
        if (other.value == null && this.value != null) {
            return false;
        }
        if (other.value != null && this.value == null) {
            return false;
        }
        if (other.value == null && this.value == null) {
            return true;
        }
        return other.value.equals(this.value);
    }
}

