/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypesException;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprValidationPropertyException;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprIdentNode
extends ExprNode {
    private final String unresolvedPropertyName;
    private String streamOrPropertyName;
    private String resolvedStreamName;
    private String resolvedPropertyName;
    private EventPropertyGetter propertyGetter;
    private int streamNum = -1;
    private Class propertyType;
    private static final long serialVersionUID = 5882493771230745244L;

    public ExprIdentNode(String unresolvedPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = null;
    }

    public ExprIdentNode(String unresolvedPropertyName, String streamOrPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        if (streamOrPropertyName == null) {
            throw new IllegalArgumentException("Stream (or property name) name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = streamOrPropertyName;
    }

    public String getUnresolvedPropertyName() {
        return this.unresolvedPropertyName;
    }

    public String getStreamOrPropertyName() {
        return this.streamOrPropertyName;
    }

    public void setStreamOrPropertyName(String streamOrPropertyName) {
        this.streamOrPropertyName = streamOrPropertyName;
    }

    public String getFullUnresolvedName() {
        if (this.streamOrPropertyName == null) {
            return this.unresolvedPropertyName;
        }
        return this.streamOrPropertyName + "." + this.unresolvedPropertyName;
    }

    @Override
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = ExprIdentNode.getTypeFromStream(streamTypeService, this.unresolvedPropertyName, this.streamOrPropertyName);
        this.resolvedStreamName = propertyInfoPair.getSecond();
        this.streamNum = propertyInfoPair.getFirst().getStreamNum();
        this.propertyType = propertyInfoPair.getFirst().getPropertyType();
        this.resolvedPropertyName = propertyInfoPair.getFirst().getPropertyName();
        this.propertyGetter = propertyInfoPair.getFirst().getStreamEventType().getGetter(this.resolvedPropertyName);
        if (this.propertyGetter == null) {
            throw new ExprValidationException("Property getter returned was invalid for property '" + this.unresolvedPropertyName + "'");
        }
    }

    @Override
    public Class getType() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.propertyType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.streamNum;
    }

    public String getResolvedStreamName() {
        if (this.resolvedStreamName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedStreamName;
    }

    public String getResolvedPropertyName() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedPropertyName;
    }

    public String getResolvedPropertyNameRoot() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        if (this.resolvedPropertyName.indexOf(91) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(91));
        }
        if (this.resolvedPropertyName.indexOf(40) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(40));
        }
        if (this.resolvedPropertyName.indexOf(46) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(46));
        }
        return this.resolvedPropertyName;
    }

    protected static Pair<PropertyResolutionDescriptor, String> getTypeFromStream(StreamTypeService streamTypeService, String unresolvedPropertyName, String streamOrPropertyName) throws ExprValidationPropertyException {
        if (streamOrPropertyName == null) {
            PropertyResolutionDescriptor propertyInfo;
            try {
                propertyInfo = streamTypeService.resolveByPropertyName(unresolvedPropertyName);
            }
            catch (StreamTypesException ex) {
                String suggestion = ExprIdentNode.getSuggestion(ex);
                if (suggestion != null) {
                    throw new ExprValidationPropertyException(ex.getMessage() + suggestion);
                }
                throw new ExprValidationPropertyException(ex.getMessage());
            }
            catch (PropertyAccessException ex) {
                throw new ExprValidationPropertyException(ex.getMessage());
            }
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, propertyInfo.getStreamName());
        }
        try {
            PropertyResolutionDescriptor propertyInfo = streamTypeService.resolveByStreamAndPropName(streamOrPropertyName, unresolvedPropertyName);
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, streamOrPropertyName);
        }
        catch (StreamTypesException ex) {
            StreamTypesException typeExceptionOne = ex;
            String propertyNameCandidate = streamOrPropertyName + '.' + unresolvedPropertyName;
            try {
                PropertyResolutionDescriptor propertyInfo = streamTypeService.resolveByPropertyName(propertyNameCandidate);
                return new Pair<PropertyResolutionDescriptor, Object>(propertyInfo, null);
            }
            catch (StreamTypesException ex2) {
                StreamTypesException typeExceptionTwo = ex2;
                String suggestionOne = ExprIdentNode.getSuggestion(typeExceptionOne);
                String suggestionTwo = ExprIdentNode.getSuggestion(typeExceptionTwo);
                if (suggestionOne != null) {
                    throw new ExprValidationPropertyException(typeExceptionOne.getMessage() + suggestionOne);
                }
                if (suggestionTwo != null) {
                    throw new ExprValidationPropertyException(typeExceptionTwo.getMessage() + suggestionTwo);
                }
                throw new ExprValidationPropertyException("Failed to resolve property '" + propertyNameCandidate + "' to a stream or nested property in a stream");
            }
        }
    }

    private static String getSuggestion(StreamTypesException ex) {
        if (ex == null) {
            return null;
        }
        if (ex.getOptionalSuggestion() == null) {
            return null;
        }
        if (ex.getOptionalSuggestion().getFirst() > 3) {
            return null;
        }
        return " (did you mean '" + ex.getOptionalSuggestion().getSecond() + "'?)";
    }

    public String toString() {
        return "unresolvedPropertyName=" + this.unresolvedPropertyName + " streamOrPropertyName=" + this.streamOrPropertyName + " resolvedPropertyName=" + this.resolvedPropertyName + " propertyInfo.pos=" + this.streamNum + " propertyInfo.type=" + this.propertyType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return this.propertyGetter.get(event);
    }

    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return false;
        }
        return this.propertyGetter.isExistsProperty(event);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        if (this.streamOrPropertyName != null) {
            buffer.append(ASTFilterSpecHelper.unescapeDot(this.streamOrPropertyName)).append('.');
        }
        buffer.append(ASTFilterSpecHelper.unescapeDot(this.unresolvedPropertyName));
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprIdentNode)) {
            return false;
        }
        ExprIdentNode other = (ExprIdentNode)node;
        if (this.streamNum == -1) {
            throw new IllegalStateException("ExprIdentNode has not been validated");
        }
        return other.streamNum == this.streamNum && other.resolvedPropertyName.equals(this.resolvedPropertyName);
    }
}

