/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.MinMaxTypeEnum;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExprMinMaxRowNode
extends ExprNode {
    private MinMaxTypeEnum minMaxTypeEnum;
    private Class resultType;
    private transient MinMaxTypeEnum.Computer computer;
    private static final long serialVersionUID = -5244192656164983580L;

    public ExprMinMaxRowNode(MinMaxTypeEnum minMaxTypeEnum) {
        this.minMaxTypeEnum = minMaxTypeEnum;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("MinMax node must have at least 2 child nodes");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        Class childTypeOne = this.getChildNodes().get(0).getType();
        Class childTypeTwo = this.getChildNodes().get(1).getType();
        this.resultType = JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo);
        for (int i = 2; i < this.getChildNodes().size(); ++i) {
            this.resultType = JavaClassHelper.getArithmaticCoercionType(this.resultType, this.getChildNodes().get(i).getType());
        }
        ExprNode[] childNodes = this.getChildNodes().toArray(new ExprNode[this.getChildNodes().size()]);
        if (this.resultType == BigInteger.class) {
            SimpleNumberBigIntegerCoercer[] convertors = new SimpleNumberBigIntegerCoercer[childNodes.length];
            for (int i = 0; i < childNodes.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigInteger(childNodes[i].getType());
            }
            this.computer = new MinMaxTypeEnum.ComputerBigIntCoerce(childNodes, convertors, this.minMaxTypeEnum == MinMaxTypeEnum.MAX);
        } else if (this.resultType == BigDecimal.class) {
            SimpleNumberBigDecimalCoercer[] convertors = new SimpleNumberBigDecimalCoercer[childNodes.length];
            for (int i = 0; i < childNodes.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigDecimal(childNodes[i].getType());
            }
            this.computer = new MinMaxTypeEnum.ComputerBigDecCoerce(childNodes, convertors, this.minMaxTypeEnum == MinMaxTypeEnum.MAX);
        } else {
            this.computer = this.minMaxTypeEnum == MinMaxTypeEnum.MAX ? new MinMaxTypeEnum.MaxComputerDoubleCoerce(childNodes) : new MinMaxTypeEnum.MinComputerDoubleCoerce(childNodes);
        }
    }

    public Class getType() {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Number result = this.computer.execute(eventsPerStream, isNewData, exprEvaluatorContext);
        if (result == null) {
            return null;
        }
        return JavaClassHelper.coerceBoxed(result, this.resultType);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.minMaxTypeEnum.getExpressionText());
        buffer.append('(');
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        for (int i = 2; i < this.getChildNodes().size(); ++i) {
            buffer.append(',');
            buffer.append(this.getChildNodes().get(i).toExpressionString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprMinMaxRowNode)) {
            return false;
        }
        ExprMinMaxRowNode other = (ExprMinMaxRowNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum;
    }
}

