/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionNode;
import com.espertech.esper.epl.expression.ExprStaticMethodNode;
import com.espertech.esper.epl.expression.ExprStreamInstanceMethodNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprValidator;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExprNode
implements ExprValidator,
ExprEvaluator,
MetaDefItem,
Serializable {
    private static final long serialVersionUID = 0L;
    private final ArrayList<ExprNode> childNodes = new ArrayList();
    private static final Log log = LogFactory.getLog(ExprNode.class);

    public abstract String toExpressionString();

    public abstract boolean isConstantResult();

    public abstract boolean equalsNode(ExprNode var1);

    public ExprNode getValidatedSubtree(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        ExprNode result = this;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            this.childNodes.set(i, this.childNodes.get(i).getValidatedSubtree(streamTypeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService, exprEvaluatorContext));
        }
        try {
            this.validate(streamTypeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService, exprEvaluatorContext);
        }
        catch (ExprValidationException e) {
            if (this instanceof ExprIdentNode) {
                ExprIdentNode identNode = (ExprIdentNode)this;
                try {
                    result = this.resolveStaticMethodOrField(identNode, streamTypeService, methodResolutionService, e, timeProvider, variableService, exprEvaluatorContext);
                }
                catch (ExprValidationException ex) {
                    result = this.resolveAsStreamName(identNode, streamTypeService, e, exprEvaluatorContext);
                }
            }
            if (this instanceof ExprStaticMethodNode) {
                ExprStaticMethodNode staticMethodNode = (ExprStaticMethodNode)this;
                result = this.resolveInstanceMethod(staticMethodNode, streamTypeService, methodResolutionService, e, exprEvaluatorContext);
            }
            throw e;
        }
        return result;
    }

    private ExprNode resolveInstanceMethod(ExprStaticMethodNode staticMethodNode, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprValidationException existingException, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        String streamName = staticMethodNode.getClassName();
        boolean streamFound = false;
        for (String name : streamTypeService.getStreamNames()) {
            if (!name.equals(streamName)) continue;
            streamFound = true;
        }
        String methodName = staticMethodNode.getMethodName();
        ExprStreamInstanceMethodNode exprStream = new ExprStreamInstanceMethodNode(streamName, methodName);
        for (ExprNode childNode : staticMethodNode.getChildNodes()) {
            exprStream.addChildNode(childNode);
        }
        try {
            exprStream.validate(streamTypeService, methodResolutionService, null, null, null, exprEvaluatorContext);
        }
        catch (ExprValidationException ex) {
            if (streamFound) {
                throw ex;
            }
            throw existingException;
        }
        return exprStream;
    }

    private ExprNode resolveAsStreamName(ExprIdentNode identNode, StreamTypeService streamTypeService, ExprValidationException existingException, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        ExprStreamUnderlyingNode exprStream = new ExprStreamUnderlyingNode(identNode.getUnresolvedPropertyName());
        try {
            exprStream.validate(streamTypeService, null, null, null, null, exprEvaluatorContext);
        }
        catch (ExprValidationException ex) {
            throw existingException;
        }
        return exprStream;
    }

    public void accept(ExprNodeVisitor visitor) {
        if (visitor.isVisit(this)) {
            visitor.visit(this);
            for (ExprNode childNode : this.childNodes) {
                childNode.accept(visitor);
            }
        }
    }

    public void accept(ExprNodeVisitorWithParent visitor) {
        if (visitor.isVisit(this)) {
            visitor.visit(this, null);
            for (ExprNode childNode : this.childNodes) {
                childNode.acceptChildnodes(visitor, this);
            }
        }
    }

    protected void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        if (visitor.isVisit(this)) {
            visitor.visit(this, parent);
            for (ExprNode childNode : this.childNodes) {
                childNode.acceptChildnodes(visitor, this);
            }
        }
    }

    public final void addChildNode(ExprNode childNode) {
        this.childNodes.add(childNode);
    }

    public final ArrayList<ExprNode> getChildNodes() {
        return this.childNodes;
    }

    public final void dumpDebug(String prefix) {
        if (log.isDebugEnabled()) {
            log.debug(".dumpDebug " + prefix + this.toString());
        }
        for (ExprNode node : this.childNodes) {
            node.dumpDebug(prefix + "  ");
        }
    }

    private ExprNode resolveStaticMethodOrField(ExprIdentNode identNode, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprValidationException propertyException, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        MappedPropertyParseResult parse;
        StringBuffer mappedProperty = new StringBuffer(identNode.getUnresolvedPropertyName());
        if (identNode.getStreamOrPropertyName() != null) {
            mappedProperty.insert(0, identNode.getStreamOrPropertyName() + '.');
        }
        if ((parse = ExprNode.parseMappedProperty(mappedProperty.toString())) == null) {
            ExprConstantNode constNode = this.resolveIdentAsEnumConst(mappedProperty.toString(), methodResolutionService);
            if (constNode == null) {
                throw propertyException;
            }
            return constNode;
        }
        if (parse.getClassName() != null) {
            ExprStaticMethodNode result = new ExprStaticMethodNode(parse.getClassName(), parse.getMethodName(), methodResolutionService.isUdfCache());
            result.addChildNode(new ExprConstantNode(parse.getArgString()));
            try {
                result.validate(streamTypeService, methodResolutionService, null, timeProvider, variableService, exprEvaluatorContext);
            }
            catch (ExprValidationException e) {
                throw new ExprValidationException("Failed to resolve " + mappedProperty + " as either an event property or as a static method invocation");
            }
            return result;
        }
        try {
            AggregationSupport aggregation = methodResolutionService.resolveAggregation(parse.getMethodName());
            ExprPlugInAggFunctionNode result = new ExprPlugInAggFunctionNode(false, aggregation, parse.getMethodName());
            result.addChildNode(new ExprConstantNode(parse.getArgString()));
            try {
                result.validate(streamTypeService, methodResolutionService, null, timeProvider, variableService, exprEvaluatorContext);
            }
            catch (RuntimeException e) {
                throw new ExprValidationException("Plug-in aggregation function '" + parse.getMethodName() + "' failed validation: " + e.getMessage());
            }
            return result;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving aggregation: " + e.getMessage(), e);
        }
        throw propertyException;
    }

    private ExprConstantNode resolveIdentAsEnumConst(String constant, MethodResolutionService methodResolutionService) throws ExprValidationException {
        Object enumValue = JavaClassHelper.resolveIdentAsEnumConst(constant, methodResolutionService, null);
        if (enumValue != null) {
            return new ExprConstantNode(enumValue);
        }
        return null;
    }

    protected static MappedPropertyParseResult parseMappedProperty(String property) {
        int indexFirstDoubleQuote = property.indexOf("\"");
        int indexFirstSingleQuote = property.indexOf("'");
        if (indexFirstSingleQuote == -1 && indexFirstDoubleQuote == -1) {
            return null;
        }
        int startArg = indexFirstSingleQuote != -1 && indexFirstDoubleQuote != -1 ? (indexFirstSingleQuote < indexFirstDoubleQuote ? indexFirstSingleQuote : indexFirstDoubleQuote) : (indexFirstSingleQuote != -1 ? indexFirstSingleQuote : indexFirstDoubleQuote);
        int indexLastDoubleQuote = property.lastIndexOf("\"");
        int indexLastSingleQuote = property.lastIndexOf("'");
        if (indexLastSingleQuote == -1 && indexLastDoubleQuote == -1) {
            return null;
        }
        int endArg = indexLastSingleQuote != -1 && indexLastDoubleQuote != -1 ? (indexLastSingleQuote > indexLastDoubleQuote ? indexLastSingleQuote : indexLastDoubleQuote) : (indexLastSingleQuote != -1 ? indexLastSingleQuote : indexLastDoubleQuote);
        String argument = property.substring(startArg + 1, endArg);
        String[] splitDots = property.split("[\\.]");
        if (splitDots.length == 0) {
            return null;
        }
        int indexMethod = -1;
        for (int i = 0; i < splitDots.length; ++i) {
            if (!splitDots[i].contains("(")) continue;
            indexMethod = i;
            break;
        }
        if (indexMethod == -1) {
            return null;
        }
        String method = splitDots[indexMethod];
        int indexParan = method.indexOf("(");
        if ((method = method.substring(0, indexParan)).length() == 0) {
            return null;
        }
        if (splitDots.length == 1) {
            return new MappedPropertyParseResult(null, method, argument);
        }
        StringBuffer clazz = new StringBuffer();
        for (int i = 0; i < indexMethod; ++i) {
            if (i > 0) {
                clazz.append('.');
            }
            clazz.append(splitDots[i]);
        }
        return new MappedPropertyParseResult(clazz.toString(), method, argument);
    }

    protected static class MappedPropertyParseResult {
        private String className;
        private String methodName;
        private String argString;

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getArgString() {
            return this.argString;
        }

        public MappedPropertyParseResult(String className, String methodName, String argString) {
            this.className = className;
            this.methodName = methodName;
            this.argString = argString;
        }
    }
}

