/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprStreamInstanceMethodNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;

public class ExprNodeSummaryVisitor
implements ExprNodeVisitor {
    private boolean hasProperties;
    private boolean hasAggregation;
    private boolean hasSubselect;
    private boolean hasStreamSelect;
    private boolean hasPreviousPrior;

    public boolean isVisit(ExprNode exprNode) {
        return true;
    }

    public void visit(ExprNode exprNode) {
        if (exprNode instanceof ExprIdentNode) {
            this.hasProperties = true;
        } else if (exprNode instanceof ExprSubselectNode) {
            this.hasSubselect = true;
        } else if (exprNode instanceof ExprAggregateNode) {
            this.hasAggregation = true;
        } else if (exprNode instanceof ExprStreamUnderlyingNode || exprNode instanceof ExprStreamInstanceMethodNode) {
            this.hasStreamSelect = true;
        } else if (exprNode instanceof ExprPriorNode || exprNode instanceof ExprPreviousNode) {
            this.hasPreviousPrior = true;
        }
    }

    public boolean isPlain() {
        return !(this.hasProperties | this.hasAggregation | this.hasSubselect | this.hasStreamSelect | this.hasPreviousPrior);
    }

    public String getMessage() {
        if (this.hasProperties) {
            return "event properties";
        }
        if (this.hasAggregation) {
            return "aggregation functions";
        }
        if (this.hasSubselect) {
            return "sub-selects";
        }
        if (this.hasStreamSelect) {
            return "stream selects or event instance methods";
        }
        if (this.hasPreviousPrior) {
            return "previous or prior functions";
        }
        return null;
    }
}

