/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprPlugInAggFunctionNode
extends ExprAggregateNode {
    private AggregationSupport aggregationSupport;
    private static final long serialVersionUID = 4512085880102791194L;

    public ExprPlugInAggFunctionNode(boolean distinct, AggregationSupport aggregationSupport, String functionName) {
        super(distinct);
        this.aggregationSupport = aggregationSupport;
        aggregationSupport.setFunctionName(functionName);
    }

    public AggregationMethod validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() > 1) {
            Class[] parameterTypes = new Class[this.getChildNodes().size()];
            Object[] constant = new Object[this.getChildNodes().size()];
            boolean[] isConstant = new boolean[this.getChildNodes().size()];
            int count = 0;
            for (ExprNode child : this.getChildNodes()) {
                if (child.isConstantResult()) {
                    isConstant[count] = true;
                    constant[count] = child.evaluate(null, true, exprEvaluatorContext);
                }
                parameterTypes[count] = child.getType();
                ++count;
            }
            this.aggregationSupport.validateMultiParameter(parameterTypes, isConstant, constant);
        } else if (this.getChildNodes().size() == 1) {
            Class childType = this.getChildNodes().get(0).getType();
            try {
                this.aggregationSupport.validate(childType);
            }
            catch (RuntimeException ex) {
                throw new ExprValidationException("Plug-in aggregation function '" + this.aggregationSupport.getFunctionName() + "' failed validation: " + ex.getMessage());
            }
        }
        return this.aggregationSupport;
    }

    public String getAggregationFunctionName() {
        return this.aggregationSupport.getFunctionName();
    }

    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprPlugInAggFunctionNode)) {
            return false;
        }
        ExprPlugInAggFunctionNode other = (ExprPlugInAggFunctionNode)node;
        return other.getAggregationFunctionName().equals(this.getAggregationFunctionName());
    }
}

