/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.ViewCapDataWindowAccess;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.RandomAccessByIndex;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;

public class ExprPreviousNode
extends ExprNode
implements ViewResourceCallback {
    private static final long serialVersionUID = 0L;
    private Class resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private boolean isConstantIndex;
    private transient RandomAccessByIndexGetter randomAccessGetter;
    private transient RelativeAccessByEventNIndexMap relativeAccessGetter;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() > 2 || this.getChildNodes().isEmpty()) {
            throw new ExprValidationException("Previous node must have 1 or 2 child nodes");
        }
        if (this.getChildNodes().size() == 1) {
            this.getChildNodes().add(0, new ExprConstantNode(1));
        }
        if (this.getChildNodes().get(1) instanceof ExprConstantNode) {
            ExprNode first = this.getChildNodes().get(0);
            ExprNode second = this.getChildNodes().get(1);
            this.getChildNodes().clear();
            this.getChildNodes().add(second);
            this.getChildNodes().add(first);
        }
        if (this.getChildNodes().get(0).isConstantResult()) {
            ExprNode constantNode = this.getChildNodes().get(0);
            Object value = constantNode.evaluate(null, false, exprEvaluatorContext);
            if (!(value instanceof Number)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            Number valueNumber = (Number)value;
            if (JavaClassHelper.isFloatingPointNumber(valueNumber)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            this.constantIndexNumber = valueNumber.intValue();
            this.isConstantIndex = true;
        }
        if (this.getChildNodes().get(1) instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes().get(1);
            this.streamNumber = identNode.getStreamId();
            this.resultType = this.getChildNodes().get(1).getType();
        } else if (this.getChildNodes().get(1) instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode streamNode = (ExprStreamUnderlyingNode)this.getChildNodes().get(1);
            this.streamNumber = streamNode.getStreamId();
            this.resultType = this.getChildNodes().get(1).getType();
        } else {
            throw new ExprValidationException("Previous function requires an event property as parameter");
        }
        if (viewResourceDelegate == null) {
            throw new ExprValidationException("Previous function cannot be used in this context");
        }
        if (!viewResourceDelegate.requestCapability(this.streamNumber, new ViewCapDataWindowAccess(), this)) {
            throw new ExprValidationException("Previous function requires a single data window view onto the stream");
        }
    }

    public Class getType() {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Integer index;
        if (this.isConstantIndex) {
            index = this.constantIndexNumber;
        } else {
            Object indexResult = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (indexResult == null) {
                return null;
            }
            index = ((Number)indexResult).intValue();
        }
        EventBean substituteEvent = null;
        if (this.randomAccessGetter != null) {
            RandomAccessByIndex randomAccess = this.randomAccessGetter.getAccessor();
            if (isNewData) {
                substituteEvent = randomAccess.getNewData(index);
            }
        } else if (isNewData) {
            EventBean evalEvent = eventsPerStream[this.streamNumber];
            IStreamRelativeAccess relativeAccess = this.relativeAccessGetter.getAccessor(evalEvent);
            substituteEvent = relativeAccess.getRelativeToEvent(evalEvent, index);
        }
        if (substituteEvent == null) {
            return null;
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("prev(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPreviousNode;
    }

    public void setViewResource(Object resource) {
        if (resource instanceof RandomAccessByIndexGetter) {
            this.randomAccessGetter = (RandomAccessByIndexGetter)resource;
        } else if (resource instanceof RelativeAccessByEventNIndexMap) {
            this.relativeAccessGetter = (RelativeAccessByEventNIndexMap)resource;
        } else {
            throw new IllegalArgumentException("View resource " + resource.getClass() + " not recognized by expression node");
        }
    }
}

