/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.DuplicatePropertyException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.PropertyNotFoundException;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.schedule.TimeProvider;

public class ExprVariableNode
extends ExprNode {
    private static final long serialVersionUID = 0L;
    private final String variableName;
    private final String optSubPropName;
    private Class variableType;
    private boolean isPrimitive;
    private transient VariableReader reader;
    private transient EventPropertyGetter eventTypeGetter;

    public ExprVariableNode(String variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException("Variables name is null");
        }
        int indexOfDot = variableName.indexOf(46);
        if (indexOfDot != -1) {
            this.optSubPropName = variableName.substring(indexOfDot + 1, variableName.length());
            this.variableName = variableName.substring(0, indexOfDot);
        } else {
            this.variableName = variableName;
            this.optSubPropName = null;
        }
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.reader = variableService.getReader(this.variableName);
        if (this.reader == null) {
            throw new ExprValidationException("A variable by name '" + this.variableName + " has not been declared");
        }
        boolean hasPropertyAgnosticType = false;
        EventType[] types = streamTypeService.getEventTypes();
        for (int i = 0; i < streamTypeService.getEventTypes().length; ++i) {
            if (!(types[i] instanceof EventTypeSPI)) continue;
            hasPropertyAgnosticType |= ((EventTypeSPI)types[i]).getMetadata().isPropertyAgnostic();
        }
        if (!hasPropertyAgnosticType) {
            try {
                streamTypeService.resolveByPropertyName(this.variableName);
                throw new ExprValidationException("The variable by name '" + this.variableName + "' is ambigous to a property of the same name");
            }
            catch (DuplicatePropertyException e) {
                throw new ExprValidationException("The variable by name '" + this.variableName + "' is ambigous to a property of the same name");
            }
            catch (PropertyNotFoundException e) {
                // empty catch block
            }
        }
        this.variableType = this.reader.getType();
        boolean bl = this.isPrimitive = this.reader.getEventType() == null;
        if (this.optSubPropName != null) {
            if (this.reader.getEventType() == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + this.variableName + "'");
            }
            this.eventTypeGetter = this.reader.getEventType().getGetter(this.optSubPropName);
            if (this.eventTypeGetter == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + this.variableName + "'");
            }
            this.variableType = this.reader.getEventType().getPropertyType(this.optSubPropName);
        }
    }

    public Class getType() {
        if (this.variableType == null) {
            throw new IllegalStateException("Variables node has not been validated");
        }
        return this.variableType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public String toString() {
        return "variableName=" + this.variableName;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = this.reader.getValue();
        if (this.isPrimitive) {
            return value;
        }
        if (value == null) {
            return null;
        }
        EventBean event = (EventBean)value;
        if (this.optSubPropName == null) {
            return event.getUnderlying();
        }
        return this.eventTypeGetter.get(event);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.variableName);
        if (this.optSubPropName != null) {
            buffer.append(".");
            buffer.append(this.optSubPropName);
        }
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprVariableNode)) {
            return false;
        }
        ExprVariableNode that = (ExprVariableNode)node;
        if (this.optSubPropName != null ? !this.optSubPropName.equals(that.optSubPropName) : that.optSubPropName != null) {
            return false;
        }
        return that.variableName.equals(this.variableName);
    }
}

