/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.SubselectEvalStrategy;
import com.espertech.esper.type.RelationalOpEnum;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubselectEvalStrategyRelOpAll
implements SubselectEvalStrategy {
    private final RelationalOpEnum.Computer computer;
    private final ExprNode valueExpr;
    private final ExprNode selectClauseExpr;
    private final ExprNode filterExpr;

    public SubselectEvalStrategyRelOpAll(RelationalOpEnum.Computer computer, ExprNode valueExpr, ExprNode selectClause, ExprNode filterExpr) {
        this.computer = computer;
        this.valueExpr = valueExpr;
        this.selectClauseExpr = selectClause;
        this.filterExpr = filterExpr;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, Set<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueLeft = this.valueExpr.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (matchingEvents == null) {
            return true;
        }
        if (matchingEvents.size() == 0) {
            return true;
        }
        EventBean[] events = new EventBean[eventsPerStream.length + 1];
        System.arraycopy(eventsPerStream, 0, events, 1, eventsPerStream.length);
        boolean hasRows = false;
        boolean hasNullRow = false;
        Iterator<EventBean> i$ = matchingEvents.iterator();
        while (i$.hasNext()) {
            Boolean pass;
            EventBean subselectEvent;
            events[0] = subselectEvent = i$.next();
            if (this.filterExpr != null && ((pass = (Boolean)this.filterExpr.evaluate(events, true, exprEvaluatorContext)) == null || !pass.booleanValue())) continue;
            hasRows = true;
            Object valueRight = this.selectClauseExpr != null ? this.selectClauseExpr.evaluate(events, true, exprEvaluatorContext) : events[0].getUnderlying();
            if (valueRight == null) {
                hasNullRow = true;
                continue;
            }
            if (valueLeft == null || this.computer.compare(valueLeft, valueRight)) continue;
            return false;
        }
        if (!hasRows) {
            return true;
        }
        if (valueLeft == null) {
            return null;
        }
        if (hasNullRow) {
            return null;
        }
        return true;
    }
}

