/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.QueryStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.view.HistoricalEventViewable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalDataQueryStrategy
implements QueryStrategy {
    private final int myStreamNumber;
    private final int historicalStreamNumber;
    private final HistoricalEventViewable historicalEventViewable;
    private final EventBean[][] lookupRows1Event;
    private final boolean isOuterJoin;
    private final ExprNode outerJoinCompareNode;
    private final HistoricalIndexLookupStrategy indexLookupStrategy;
    private final PollResultIndexingStrategy pollResultIndexingStrategy;

    public HistoricalDataQueryStrategy(int myStreamNumber, int historicalStreamNumber, HistoricalEventViewable historicalEventViewable, boolean isOuterJoin, ExprNode outerJoinCompareNode, HistoricalIndexLookupStrategy indexLookupStrategy, PollResultIndexingStrategy pollResultIndexingStrategy) {
        this.myStreamNumber = myStreamNumber;
        this.historicalStreamNumber = historicalStreamNumber;
        this.historicalEventViewable = historicalEventViewable;
        this.isOuterJoin = isOuterJoin;
        this.outerJoinCompareNode = outerJoinCompareNode;
        this.lookupRows1Event = new EventBean[1][];
        this.lookupRows1Event[0] = new EventBean[2];
        this.indexLookupStrategy = indexLookupStrategy;
        this.pollResultIndexingStrategy = pollResultIndexingStrategy;
    }

    @Override
    public void lookup(EventBean[] lookupEvents, Set<MultiKey<EventBean>> joinSet, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[][] lookupRows;
        if (lookupEvents.length == 1) {
            lookupRows = this.lookupRows1Event;
            lookupRows[0][this.myStreamNumber] = lookupEvents[0];
        } else {
            lookupRows = new EventBean[lookupEvents.length][];
            for (int i = 0; i < lookupEvents.length; ++i) {
                lookupRows[i] = new EventBean[2];
                lookupRows[i][this.myStreamNumber] = lookupEvents[i];
            }
        }
        EventTable[] indexPerLookupRow = this.historicalEventViewable.poll(lookupRows, this.pollResultIndexingStrategy, exprEvaluatorContext);
        int count = 0;
        for (EventTable index : indexPerLookupRow) {
            Iterator<EventBean> subsetIter = this.indexLookupStrategy.lookup(lookupEvents[count], index);
            if (this.isOuterJoin && (subsetIter == null || !subsetIter.hasNext())) {
                EventBean[] resultRow = new EventBean[2];
                resultRow[this.myStreamNumber] = lookupEvents[count];
                joinSet.add(new MultiKey<EventBean>(resultRow));
            } else {
                EventBean[] resultRow;
                boolean foundMatch = false;
                if (subsetIter != null) {
                    while (subsetIter.hasNext()) {
                        resultRow = new EventBean[2];
                        resultRow[this.myStreamNumber] = lookupEvents[count];
                        resultRow[this.historicalStreamNumber] = subsetIter.next();
                        if (this.outerJoinCompareNode != null) {
                            Boolean compareResult = (Boolean)this.outerJoinCompareNode.evaluate(resultRow, true, exprEvaluatorContext);
                            if (compareResult == null || !compareResult.booleanValue()) continue;
                            joinSet.add(new MultiKey<EventBean>(resultRow));
                            foundMatch = true;
                            continue;
                        }
                        joinSet.add(new MultiKey<EventBean>(resultRow));
                    }
                }
                if (this.isOuterJoin && !foundMatch) {
                    resultRow = new EventBean[2];
                    resultRow[this.myStreamNumber] = lookupEvents[count];
                    joinSet.add(new MultiKey<EventBean>(resultRow));
                }
            }
            ++count;
        }
    }
}

