/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.StreamJoinAnalysisResult;
import com.espertech.esper.epl.expression.ExprAndNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.ExecNodeQueryStrategy;
import com.espertech.esper.epl.join.HistoricalDataQueryStrategy;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategyIndex;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategyNoIndex;
import com.espertech.esper.epl.join.JoinSetComposer;
import com.espertech.esper.epl.join.JoinSetComposerFactory;
import com.espertech.esper.epl.join.JoinSetComposerHistoricalImpl;
import com.espertech.esper.epl.join.JoinSetComposerImpl;
import com.espertech.esper.epl.join.JoinSetComposerStreamToWinImpl;
import com.espertech.esper.epl.join.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.PollResultIndexingStrategyIndex;
import com.espertech.esper.epl.join.PollResultIndexingStrategyIndexCoerce;
import com.espertech.esper.epl.join.PollResultIndexingStrategyNoIndex;
import com.espertech.esper.epl.join.QueryStrategy;
import com.espertech.esper.epl.join.exec.ExecNode;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzer;
import com.espertech.esper.epl.join.plan.HistoricalDependencyGraph;
import com.espertech.esper.epl.join.plan.OuterJoinAnalyzer;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanBuilder;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.join.table.PropertyIndTableCoerceAll;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.join.table.UnindexedEventTable;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinSetComposerFactoryImpl
implements JoinSetComposerFactory {
    private static final Log log = LogFactory.getLog(JoinSetComposerFactoryImpl.class);

    @Override
    public JoinSetComposer makeComposer(List<OuterJoinDesc> outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, String[] streamNames, Viewable[] streamViews, SelectClauseStreamSelectorEnum selectStreamSelectorEnum, StreamJoinAnalysisResult streamJoinAnalysisResult, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        QueryStrategy driver;
        int unidirectionalStream;
        HistoricalDependencyGraph historicalDependencyGraph = new HistoricalDependencyGraph(streamTypes.length);
        boolean[] isHistorical = new boolean[streamViews.length];
        boolean hasHistorical = false;
        for (int i = 0; i < streamViews.length; ++i) {
            if (!(streamViews[i] instanceof HistoricalEventViewable)) continue;
            HistoricalEventViewable historicalViewable = (HistoricalEventViewable)streamViews[i];
            isHistorical[i] = true;
            hasHistorical = true;
            historicalDependencyGraph.addDependency(i, historicalViewable.getRequiredStreams());
        }
        if (hasHistorical && streamViews.length == 2) {
            return this.makeComposerHistorical2Stream(outerJoinDescList, optionalFilterNode, streamTypes, streamViews, exprEvaluatorContext);
        }
        QueryGraph queryGraph = new QueryGraph(streamTypes.length);
        if (!outerJoinDescList.isEmpty()) {
            OuterJoinAnalyzer.analyze(outerJoinDescList, queryGraph);
            if (log.isDebugEnabled()) {
                log.debug(".makeComposer After outer join queryGraph=\n" + queryGraph);
            }
        } else if (optionalFilterNode != null) {
            FilterExprAnalyzer.analyze(optionalFilterNode, queryGraph);
            if (log.isDebugEnabled()) {
                log.debug(".makeComposer After filter expression queryGraph=\n" + queryGraph);
            }
            QueryGraph.fillEquivalentNav(queryGraph);
            if (log.isDebugEnabled()) {
                log.debug(".makeComposer After fill equiv. nav. queryGraph=\n" + queryGraph);
            }
        }
        HistoricalStreamIndexList[] historicalStreamIndexLists = new HistoricalStreamIndexList[streamTypes.length];
        QueryPlan queryPlan = QueryPlanBuilder.getPlan(streamTypes, outerJoinDescList, queryGraph, streamNames, hasHistorical, isHistorical, historicalDependencyGraph, historicalStreamIndexLists, exprEvaluatorContext);
        QueryPlanIndex[] indexSpecs = queryPlan.getIndexSpecs();
        EventTable[][] indexes = new EventTable[indexSpecs.length][];
        for (int streamNo = 0; streamNo < indexSpecs.length; ++streamNo) {
            if (indexSpecs[streamNo] == null) continue;
            String[][] indexProps = indexSpecs[streamNo].getIndexProps();
            Class[][] coercionTypes = indexSpecs[streamNo].getCoercionTypesPerIndex();
            indexes[streamNo] = new EventTable[indexProps.length];
            for (int indexNo = 0; indexNo < indexProps.length; ++indexNo) {
                indexes[streamNo][indexNo] = JoinSetComposerFactoryImpl.buildIndex(streamNo, indexProps[indexNo], coercionTypes[indexNo], streamTypes[streamNo]);
            }
        }
        QueryPlanNode[] queryExecSpecs = queryPlan.getExecNodeSpecs();
        QueryStrategy[] queryStrategies = new QueryStrategy[queryExecSpecs.length];
        for (int i = 0; i < queryExecSpecs.length; ++i) {
            QueryPlanNode planNode = queryExecSpecs[i];
            if (planNode == null) {
                log.debug(".makeComposer No execution node for stream " + i + " '" + streamNames[i] + "'");
                continue;
            }
            ExecNode executionNode = planNode.makeExec(indexes, streamTypes, streamViews, historicalStreamIndexLists);
            if (log.isDebugEnabled()) {
                log.debug(".makeComposer Execution nodes for stream " + i + " '" + streamNames[i] + "' : \n" + ExecNode.print(executionNode));
            }
            queryStrategies[i] = new ExecNodeQueryStrategy(i, streamTypes.length, executionNode);
        }
        if (!(streamJoinAnalysisResult.isUnidirectional() || streamJoinAnalysisResult.isPureSelfJoin() && outerJoinDescList.isEmpty())) {
            if (hasHistorical) {
                return new JoinSetComposerHistoricalImpl(indexes, queryStrategies, streamViews, exprEvaluatorContext);
            }
            return new JoinSetComposerImpl(indexes, queryStrategies, streamJoinAnalysisResult.isPureSelfJoin(), exprEvaluatorContext);
        }
        if (streamJoinAnalysisResult.getUnidirectionalStreamNumber() != -1) {
            unidirectionalStream = streamJoinAnalysisResult.getUnidirectionalStreamNumber();
            driver = queryStrategies[unidirectionalStream];
        } else {
            unidirectionalStream = 0;
            driver = queryStrategies[0];
        }
        return new JoinSetComposerStreamToWinImpl(indexes, streamJoinAnalysisResult.isPureSelfJoin(), unidirectionalStream, driver, streamJoinAnalysisResult.getUnidirectionalNonDriving());
    }

    private JoinSetComposer makeComposerHistorical2Stream(List<OuterJoinDesc> outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, Viewable[] streamViews, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        QueryStrategy[] queryStrategies = new QueryStrategy[streamTypes.length];
        int polledViewNum = 0;
        int streamViewNum = 1;
        if (streamViews[1] instanceof HistoricalEventViewable) {
            streamViewNum = 0;
            polledViewNum = 1;
        }
        boolean isAllHistoricalNoSubordinate = false;
        if (streamViews[0] instanceof HistoricalEventViewable && streamViews[1] instanceof HistoricalEventViewable) {
            HistoricalDependencyGraph graph = new HistoricalDependencyGraph(2);
            graph.addDependency(0, ((HistoricalEventViewable)streamViews[0]).getRequiredStreams());
            graph.addDependency(1, ((HistoricalEventViewable)streamViews[1]).getRequiredStreams());
            if (graph.getFirstCircularDependency() != null) {
                throw new ExprValidationException("Circular dependency detected between historical streams");
            }
            if (graph.getRootNodes().size() == 2) {
                isAllHistoricalNoSubordinate = true;
            } else if (graph.getDependenciesForStream(0).size() == 0) {
                streamViewNum = 0;
                polledViewNum = 1;
            } else {
                streamViewNum = 1;
                polledViewNum = 0;
            }
        }
        boolean isOuterJoin = false;
        ExprNode outerJoinEqualsNode = null;
        if (!outerJoinDescList.isEmpty()) {
            OuterJoinDesc outerJoinDesc = outerJoinDescList.get(0);
            if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.FULL)) {
                isOuterJoin = true;
            } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.LEFT) && streamViewNum == 0) {
                isOuterJoin = true;
            } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.RIGHT) && streamViewNum == 1) {
                isOuterJoin = true;
            }
            outerJoinEqualsNode = outerJoinDesc.makeExprNode(exprEvaluatorContext);
        }
        ExprNode filterForIndexing = null;
        if (outerJoinEqualsNode != null && optionalFilterNode != null) {
            filterForIndexing = new ExprAndNode();
            filterForIndexing.addChildNode(optionalFilterNode);
            filterForIndexing.addChildNode(outerJoinEqualsNode);
        } else if (outerJoinEqualsNode == null && optionalFilterNode != null) {
            filterForIndexing = optionalFilterNode;
        } else if (outerJoinEqualsNode != null) {
            filterForIndexing = outerJoinEqualsNode;
        }
        Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> indexStrategies = JoinSetComposerFactoryImpl.determineIndexing(filterForIndexing, streamTypes[polledViewNum], streamTypes[streamViewNum], polledViewNum, streamViewNum);
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[polledViewNum];
        queryStrategies[streamViewNum] = new HistoricalDataQueryStrategy(streamViewNum, polledViewNum, viewable, isOuterJoin, outerJoinEqualsNode, indexStrategies.getFirst(), indexStrategies.getSecond());
        if (isAllHistoricalNoSubordinate) {
            isOuterJoin = false;
            if (!outerJoinDescList.isEmpty()) {
                OuterJoinDesc outerJoinDesc = outerJoinDescList.get(0);
                if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.FULL)) {
                    isOuterJoin = true;
                } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.LEFT) && polledViewNum == 0) {
                    isOuterJoin = true;
                } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.RIGHT) && polledViewNum == 1) {
                    isOuterJoin = true;
                }
            }
            viewable = (HistoricalEventViewable)streamViews[streamViewNum];
            queryStrategies[polledViewNum] = new HistoricalDataQueryStrategy(polledViewNum, streamViewNum, viewable, isOuterJoin, outerJoinEqualsNode, new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        return new JoinSetComposerHistoricalImpl(null, queryStrategies, streamViews, exprEvaluatorContext);
    }

    private static Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> determineIndexing(ExprNode filterForIndexing, EventType polledViewType, EventType streamViewType, int polledViewStreamNum, int streamViewStreamNum) {
        if (filterForIndexing == null) {
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        QueryGraph queryGraph = new QueryGraph(2);
        FilterExprAnalyzer.analyze(filterForIndexing, queryGraph);
        return JoinSetComposerFactoryImpl.determineIndexing(queryGraph, polledViewType, streamViewType, polledViewStreamNum, streamViewStreamNum);
    }

    public static Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> determineIndexing(QueryGraph queryGraph, EventType polledViewType, EventType streamViewType, int polledViewStreamNum, int streamViewStreamNum) {
        HistoricalIndexLookupStrategyIndex strategy;
        String[] keyPropertiesJoin = queryGraph.getKeyProperties(streamViewStreamNum, polledViewStreamNum);
        String[] indexPropertiesJoin = queryGraph.getIndexProperties(streamViewStreamNum, polledViewStreamNum);
        if (keyPropertiesJoin == null || keyPropertiesJoin.length == 0) {
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        boolean mustCoerce = false;
        Class[] coercionTypes = new Class[indexPropertiesJoin.length];
        for (int i = 0; i < keyPropertiesJoin.length; ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(streamViewType.getPropertyType(keyPropertiesJoin[i]));
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(polledViewType.getPropertyType(indexPropertiesJoin[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        if (!mustCoerce) {
            PollResultIndexingStrategyIndex indexing = new PollResultIndexingStrategyIndex(polledViewStreamNum, polledViewType, indexPropertiesJoin);
            strategy = new HistoricalIndexLookupStrategyIndex(streamViewType, keyPropertiesJoin);
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
        }
        PollResultIndexingStrategyIndexCoerce indexing = new PollResultIndexingStrategyIndexCoerce(polledViewStreamNum, polledViewType, indexPropertiesJoin, coercionTypes);
        strategy = new HistoricalIndexLookupStrategyIndex(streamViewType, keyPropertiesJoin);
        return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
    }

    protected static EventTable buildIndex(int indexedStreamNum, String[] indexProps, Class[] optCoercionTypes, EventType eventType) {
        EventTable table = indexProps.length == 0 ? new UnindexedEventTable(indexedStreamNum) : (optCoercionTypes == null ? new PropertyIndexedEventTable(indexedStreamNum, eventType, indexProps, null) : new PropertyIndTableCoerceAll(indexedStreamNum, eventType, indexProps, optCoercionTypes));
        return table;
    }
}

