/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.assemble;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.epl.join.rep.Node;
import com.espertech.esper.util.IndentWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchOptionalAssemblyNode
extends BaseAssemblyNode {
    private List<Node> resultsForStream;
    private Node singleResultNode;
    private EventBean singleResultEvent;
    private boolean haveChildResults;
    private Set<EventBean> completedEvents;

    public BranchOptionalAssemblyNode(int streamNum, int numStreams) {
        super(streamNum, numStreams);
    }

    @Override
    public void init(List<Node>[] result) {
        this.resultsForStream = result[this.streamNum];
        this.singleResultNode = null;
        this.singleResultEvent = null;
        this.haveChildResults = false;
        if (this.resultsForStream != null) {
            Node node;
            Set<EventBean> nodeEvents;
            int numNodes = this.resultsForStream.size();
            if (numNodes == 1 && (nodeEvents = (node = this.resultsForStream.get(0)).getEvents()).size() == 1) {
                this.singleResultNode = node;
                this.singleResultEvent = nodeEvents.iterator().next();
            }
            if (this.singleResultNode == null) {
                this.completedEvents = new HashSet<EventBean>();
            }
        }
    }

    @Override
    public void process(List<Node>[] result) {
        if (this.resultsForStream == null) {
            return;
        }
        if (this.singleResultNode != null) {
            if (!this.haveChildResults) {
                EventBean[] row = new EventBean[this.numStreams];
                row[this.streamNum] = this.singleResultEvent;
                this.parentNode.result(row, this.streamNum, this.singleResultNode.getParentEvent(), this.singleResultNode);
            }
            return;
        }
        for (Node node : this.resultsForStream) {
            Set<EventBean> events = node.getEvents();
            for (EventBean event : events) {
                if (this.completedEvents.contains(event)) continue;
                this.processEvent(event, node);
            }
        }
    }

    @Override
    public void result(EventBean[] row, int fromStreamNum, EventBean myEvent, Node myNode) {
        row[this.streamNum] = myEvent;
        Node parentResultNode = myNode.getParent();
        this.parentNode.result(row, this.streamNum, myNode.getParentEvent(), parentResultNode);
        this.haveChildResults = true;
        if (this.singleResultNode == null) {
            this.completedEvents.add(myEvent);
        }
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("BranchOptionalAssemblyNode streamNum=" + this.streamNum);
    }

    private void processEvent(EventBean event, Node currentNode) {
        EventBean[] row = new EventBean[this.numStreams];
        row[this.streamNum] = event;
        this.parentNode.result(row, this.streamNum, currentNode.getParentEvent(), currentNode.getParent());
    }
}

