/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.assemble;

import com.espertech.esper.client.EventBean;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianUtil {
    protected static void computeCartesian(List<EventBean[]> streamOne, int[] subStreamNumsOne, List<EventBean[]> streamTwo, int[] subStreamNumsTwo, List<EventBean[]> resultList) {
        int index;
        if (streamTwo == null || streamTwo.isEmpty()) {
            if (streamOne == null || streamOne.isEmpty()) {
                return;
            }
            resultList.addAll(streamOne);
            return;
        }
        if (streamOne == null || streamOne.isEmpty()) {
            resultList.addAll(streamTwo);
            return;
        }
        int streamOneSize = streamOne.size();
        int streamTwoSize = streamTwo.size();
        if (streamOneSize == 1) {
            CartesianUtil.copyToEach(subStreamNumsOne, streamOne.get(0), streamTwo);
            resultList.addAll(streamTwo);
            return;
        }
        if (streamTwoSize == 1) {
            CartesianUtil.copyToEach(subStreamNumsTwo, streamTwo.get(0), streamOne);
            resultList.addAll(streamOne);
            return;
        }
        if (streamTwoSize > streamOneSize) {
            List<EventBean[]> holdRows = streamOne;
            int holdSize = streamOneSize;
            streamOne = streamTwo;
            streamOneSize = streamTwoSize;
            streamTwo = holdRows;
            streamTwoSize = holdSize;
            subStreamNumsTwo = subStreamNumsOne;
        }
        int cartesianTotalRows = streamOneSize * streamTwoSize;
        int numColumns = streamOne.get(0).length;
        EventBean[][] results = new EventBean[cartesianTotalRows][];
        int streamOneCount = 0;
        for (EventBean[] row : streamOne) {
            results[streamOneCount] = row;
            for (int i = 1; i < streamTwoSize; ++i) {
                EventBean[] dupRow = new EventBean[numColumns];
                System.arraycopy(row, 0, dupRow, 0, numColumns);
                index = streamOneSize * i + streamOneCount;
                results[index] = dupRow;
            }
            ++streamOneCount;
        }
        int streamTwoCount = 0;
        for (EventBean[] row : streamTwo) {
            for (int i = 0; i < streamOneSize; ++i) {
                index = streamTwoCount * streamOneSize + i;
                CartesianUtil.copy(subStreamNumsTwo, row, results[index]);
            }
            ++streamTwoCount;
        }
        resultList.addAll(Arrays.asList(results));
    }

    private static void copyToEach(int[] subStreamNums, EventBean[] sourceRow, List<EventBean[]> destRows) {
        for (EventBean[] destRow : destRows) {
            CartesianUtil.copy(subStreamNums, sourceRow, destRow);
        }
    }

    private static void copy(int[] subStreamsFrom, EventBean[] from, EventBean[] to) {
        for (int index : subStreamsFrom) {
            to[index] = from[index];
        }
    }
}

