/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.ExecNode;
import com.espertech.esper.epl.join.exec.TableLookupStrategy;
import com.espertech.esper.util.IndentWriter;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableLookupExecNode
extends ExecNode {
    private int indexedStream;
    private TableLookupStrategy lookupStrategy;

    public TableLookupExecNode(int indexedStream, TableLookupStrategy lookupStrategy) {
        this.indexedStream = indexedStream;
        this.lookupStrategy = lookupStrategy;
    }

    public TableLookupStrategy getLookupStrategy() {
        return this.lookupStrategy;
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, List<EventBean[]> result, ExprEvaluatorContext exprEvaluatorContext) {
        Set<EventBean> joinedEvents = this.lookupStrategy.lookup(lookupEvent, null, exprEvaluatorContext);
        if (joinedEvents == null) {
            return;
        }
        for (EventBean joinedEvent : joinedEvents) {
            EventBean[] events = new EventBean[prefillPath.length];
            System.arraycopy(prefillPath, 0, events, 0, events.length);
            events[this.indexedStream] = joinedEvent;
            result.add(events);
        }
    }

    public int getIndexedStream() {
        return this.indexedStream;
    }

    @Override
    public void print(IndentWriter writer) {
        writer.println("TableLookupExecNode indexedStream=" + this.indexedStream + " lookup=" + this.lookupStrategy);
    }
}

