/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.expression.ExprAndNode;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.plan.QueryGraph;

public class FilterExprAnalyzer {
    public static void analyze(ExprNode topNode, QueryGraph queryGraph) {
        if (topNode instanceof ExprEqualsNode) {
            ExprEqualsNode equalsNode = (ExprEqualsNode)topNode;
            if (!equalsNode.isNotEquals()) {
                FilterExprAnalyzer.analyzeEqualsNode(equalsNode, queryGraph);
            }
        } else if (topNode instanceof ExprAndNode) {
            ExprAndNode andNode = (ExprAndNode)topNode;
            FilterExprAnalyzer.analyzeAndNode(andNode, queryGraph);
        }
    }

    protected static void analyzeEqualsNode(ExprEqualsNode equalsNode, QueryGraph queryGraph) {
        if (!(equalsNode.getChildNodes().get(0) instanceof ExprIdentNode) || !(equalsNode.getChildNodes().get(1) instanceof ExprIdentNode)) {
            return;
        }
        ExprIdentNode identNodeLeft = (ExprIdentNode)equalsNode.getChildNodes().get(0);
        ExprIdentNode identNodeRight = (ExprIdentNode)equalsNode.getChildNodes().get(1);
        if (identNodeLeft.getStreamId() != identNodeRight.getStreamId()) {
            queryGraph.add(identNodeLeft.getStreamId(), identNodeLeft.getResolvedPropertyName(), identNodeRight.getStreamId(), identNodeRight.getResolvedPropertyName());
        }
    }

    protected static void analyzeAndNode(ExprAndNode andNode, QueryGraph queryGraph) {
        for (ExprNode childNode : andNode.getChildNodes()) {
            ExprEqualsNode equalsNode;
            if (!(childNode instanceof ExprEqualsNode) || (equalsNode = (ExprEqualsNode)childNode).isNotEquals()) continue;
            FilterExprAnalyzer.analyzeEqualsNode(equalsNode, queryGraph);
        }
    }
}

