/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalDependencyGraph {
    private final int numStreams;
    private final Map<Integer, SortedSet<Integer>> dependencies;

    public HistoricalDependencyGraph(int numStreams) {
        this.numStreams = numStreams;
        this.dependencies = new HashMap<Integer, SortedSet<Integer>>();
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        int count = 0;
        for (Map.Entry<Integer, SortedSet<Integer>> entry : this.dependencies.entrySet()) {
            writer.println("Entry " + ++count + ": from=" + entry.getKey());
            writer.println("  to=" + entry.getValue());
        }
        return buf.toString();
    }

    public void addDependency(int target, SortedSet<Integer> requiredStreams) {
        if (requiredStreams.contains(target)) {
            throw new IllegalArgumentException("Dependency between same streams is not allowed for stream " + target);
        }
        Set toSet = this.dependencies.get(target);
        if (toSet != null) {
            throw new IllegalArgumentException("Dependencies from stream " + target + " already in collection");
        }
        this.dependencies.put(target, requiredStreams);
    }

    public void addDependency(int target, int from) {
        if (target == from) {
            throw new IllegalArgumentException("Dependency between same streams is not allowed for stream " + target);
        }
        SortedSet<Integer> toSet = this.dependencies.get(target);
        if (toSet == null) {
            toSet = new TreeSet<Integer>();
            this.dependencies.put(target, toSet);
        }
        toSet.add(from);
    }

    public boolean hasDependency(int stream) {
        SortedSet<Integer> dep = this.dependencies.get(stream);
        if (dep != null) {
            return !dep.isEmpty();
        }
        return false;
    }

    public Set<Integer> getDependenciesForStream(int stream) {
        SortedSet<Integer> dep = this.dependencies.get(stream);
        if (dep != null) {
            return dep;
        }
        return Collections.emptySet();
    }

    public Map<Integer, SortedSet<Integer>> getDependencies() {
        return this.dependencies;
    }

    public Set<Integer> getRootNodes() {
        HashSet<Integer> rootNodes = new HashSet<Integer>();
        for (int i = 0; i < this.numStreams; ++i) {
            boolean found = false;
            for (Map.Entry<Integer, SortedSet<Integer>> entry : this.dependencies.entrySet()) {
                if (!entry.getValue().contains(i)) continue;
                found = true;
                break;
            }
            if (found) continue;
            rootNodes.add(i);
        }
        return rootNodes;
    }

    public Stack<Integer> getFirstCircularDependency() {
        for (int i = 0; i < this.numStreams; ++i) {
            Stack<Integer> deepDependencies = new Stack<Integer>();
            deepDependencies.push(i);
            boolean isCircular = this.recursiveDeepDepends(deepDependencies, i);
            if (!isCircular) continue;
            return deepDependencies;
        }
        return null;
    }

    private boolean recursiveDeepDepends(Stack<Integer> deepDependencies, int currentStream) {
        Set required = this.dependencies.get(currentStream);
        if (required == null) {
            return false;
        }
        for (Integer stream : required) {
            if (deepDependencies.contains(stream)) {
                return true;
            }
            deepDependencies.push(stream);
            boolean isDeep = this.recursiveDeepDepends(deepDependencies, stream);
            if (isDeep) {
                return true;
            }
            deepDependencies.pop();
        }
        return false;
    }
}

