/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.LookupInstructionExec;
import com.espertech.esper.epl.join.exec.TableLookupStrategy;
import com.espertech.esper.epl.join.plan.HistoricalDataPlanNode;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.util.IndentWriter;
import com.espertech.esper.view.Viewable;
import java.util.Arrays;

public class LookupInstructionPlan {
    private final int fromStream;
    private final String fromStreamName;
    private final int[] toStreams;
    private final TableLookupPlan[] lookupPlans;
    private final boolean[] requiredPerStream;
    private final HistoricalDataPlanNode[] historicalPlans;

    public LookupInstructionPlan(int fromStream, String fromStreamName, int[] toStreams, TableLookupPlan[] lookupPlans, HistoricalDataPlanNode[] historicalPlans, boolean[] requiredPerStream) {
        if (toStreams.length != lookupPlans.length) {
            throw new IllegalArgumentException("Invalid number of lookup plans for each stream");
        }
        if (requiredPerStream.length < lookupPlans.length) {
            throw new IllegalArgumentException("Invalid required per stream array");
        }
        if (fromStream < 0 || fromStream >= requiredPerStream.length) {
            throw new IllegalArgumentException("Invalid from stream");
        }
        this.fromStream = fromStream;
        this.fromStreamName = fromStreamName;
        this.toStreams = toStreams;
        this.lookupPlans = lookupPlans;
        this.historicalPlans = historicalPlans;
        this.requiredPerStream = requiredPerStream;
    }

    public LookupInstructionExec makeExec(EventTable[][] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, HistoricalStreamIndexList[] historicalStreamIndexLists) {
        TableLookupStrategy[] strategies = new TableLookupStrategy[this.lookupPlans.length];
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            strategies[i] = this.lookupPlans[i] != null ? this.lookupPlans[i].makeStrategy(indexesPerStream, streamTypes) : this.historicalPlans[i].makeOuterJoinStategy(streamViews, i, historicalStreamIndexLists);
        }
        return new LookupInstructionExec(this.fromStream, this.fromStreamName, this.toStreams, strategies, this.requiredPerStream);
    }

    public void print(IndentWriter writer) {
        writer.println("LookupInstructionPlan fromStream=" + this.fromStream + " fromStreamName=" + this.fromStreamName + " toStreams=" + Arrays.toString(this.toStreams));
        writer.incrIndent();
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            if (this.lookupPlans[i] != null) {
                writer.println("plan " + i + " :" + this.lookupPlans[i].toString());
                continue;
            }
            writer.println("plan " + i + " : no lookup plan");
        }
        writer.decrIndent();
    }
}

