/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.plan.HistoricalDependencyGraph;
import com.espertech.esper.epl.join.plan.NStreamOuterQueryPlanBuilder;
import com.espertech.esper.epl.join.plan.NStreamQueryPlanBuilder;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.TwoStreamQueryPlanBuilder;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.type.OuterJoinType;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryPlanBuilder {
    private static final Log log = LogFactory.getLog(QueryPlanBuilder.class);

    public static QueryPlan getPlan(EventType[] typesPerStream, List<OuterJoinDesc> outerJoinDescList, QueryGraph queryGraph, String[] streamNames, boolean hasHistorical, boolean[] isHistorical, HistoricalDependencyGraph dependencyGraph, HistoricalStreamIndexList[] historicalStreamIndexLists, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        String methodName = ".getPlan ";
        int numStreams = typesPerStream.length;
        if (numStreams < 2) {
            throw new IllegalArgumentException("Number of join stream types is less then 2");
        }
        if (outerJoinDescList.size() >= numStreams) {
            throw new IllegalArgumentException("Too many outer join descriptors found");
        }
        if (numStreams == 2) {
            OuterJoinType outerJoinType = null;
            if (!outerJoinDescList.isEmpty()) {
                outerJoinType = outerJoinDescList.get(0).getOuterJoinType();
            }
            QueryPlan queryPlan = TwoStreamQueryPlanBuilder.build(typesPerStream, queryGraph, outerJoinType);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "2-Stream queryPlan=" + queryPlan);
            }
            return queryPlan;
        }
        if (outerJoinDescList.isEmpty()) {
            QueryPlan queryPlan = NStreamQueryPlanBuilder.build(queryGraph, typesPerStream, hasHistorical, isHistorical, dependencyGraph, historicalStreamIndexLists);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "N-Stream no-outer-join queryPlan=" + queryPlan);
            }
            return queryPlan;
        }
        return NStreamOuterQueryPlanBuilder.build(queryGraph, outerJoinDescList, streamNames, typesPerStream, hasHistorical, isHistorical, dependencyGraph, historicalStreamIndexLists, exprEvaluatorContext);
    }
}

