/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.JoinSetComposerFactoryImpl;
import com.espertech.esper.epl.join.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexDesc;
import com.espertech.esper.epl.join.table.MultiIndexEventTable;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalStreamIndexList {
    private final int historicalStreamNum;
    private final EventType[] typesPerStream;
    private final QueryGraph queryGraph;
    private final TreeSet<Integer> pollingStreams;
    private Map<HistoricalStreamIndexDesc, List<Integer>> indexesUsedByStreams;
    private PollResultIndexingStrategy masterIndexingStrategy;

    public HistoricalStreamIndexList(int historicalStreamNum, EventType[] typesPerStream, QueryGraph queryGraph) {
        this.historicalStreamNum = historicalStreamNum;
        this.typesPerStream = typesPerStream;
        this.queryGraph = queryGraph;
        this.pollingStreams = new TreeSet();
    }

    public void addIndex(int streamViewStreamNum) {
        this.pollingStreams.add(streamViewStreamNum);
    }

    public Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> getStrategy(int streamViewStreamNum) {
        if (this.pollingStreams.size() == 1) {
            return JoinSetComposerFactoryImpl.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum);
        }
        if (this.indexesUsedByStreams == null) {
            this.indexesUsedByStreams = new LinkedHashMap<HistoricalStreamIndexDesc, List<Integer>>();
            for (int pollingStream : this.pollingStreams) {
                String[] indexProperties = this.queryGraph.getIndexProperties(pollingStream, this.historicalStreamNum);
                String[] keyProperties = this.queryGraph.getKeyProperties(pollingStream, this.historicalStreamNum);
                if (keyProperties == null) {
                    keyProperties = new String[]{};
                    indexProperties = new String[]{};
                }
                Class[] keyTypes = this.getPropertyTypes(this.typesPerStream[pollingStream], keyProperties);
                Class[] indexTypes = this.getPropertyTypes(this.typesPerStream[this.historicalStreamNum], indexProperties);
                HistoricalStreamIndexDesc desc = new HistoricalStreamIndexDesc(indexProperties, indexTypes, keyTypes);
                List<Integer> usedByStreams = this.indexesUsedByStreams.get(desc);
                if (usedByStreams == null) {
                    usedByStreams = new LinkedList<Integer>();
                    this.indexesUsedByStreams.put(desc, usedByStreams);
                }
                usedByStreams.add(pollingStream);
            }
            if (this.indexesUsedByStreams.size() > 1) {
                final int numIndexes = this.indexesUsedByStreams.size();
                final PollResultIndexingStrategy[] indexingStrategies = new PollResultIndexingStrategy[numIndexes];
                int count = 0;
                for (Map.Entry<HistoricalStreamIndexDesc, List<Integer>> desc : this.indexesUsedByStreams.entrySet()) {
                    int sampleStreamViewStreamNum = desc.getValue().get(0);
                    indexingStrategies[count] = JoinSetComposerFactoryImpl.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[sampleStreamViewStreamNum], this.historicalStreamNum, sampleStreamViewStreamNum).getSecond();
                    ++count;
                }
                this.masterIndexingStrategy = new PollResultIndexingStrategy(){

                    @Override
                    public EventTable index(List<EventBean> pollResult, boolean isActiveCache) {
                        EventTable[] tables = new EventTable[numIndexes];
                        for (int i = 0; i < numIndexes; ++i) {
                            tables[i] = indexingStrategies[i].index(pollResult, isActiveCache);
                        }
                        return new MultiIndexEventTable(tables);
                    }
                };
            }
        }
        if (this.indexesUsedByStreams.size() == 1) {
            return JoinSetComposerFactoryImpl.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum);
        }
        int indexUsed = 0;
        for (List<Integer> desc : this.indexesUsedByStreams.values()) {
            if (desc.contains(streamViewStreamNum)) break;
            ++indexUsed;
        }
        final int indexNumber = indexUsed;
        final HistoricalIndexLookupStrategy innerLookupStrategy = JoinSetComposerFactoryImpl.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum).getFirst();
        HistoricalIndexLookupStrategy lookupStrategy = new HistoricalIndexLookupStrategy(){

            @Override
            public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable index) {
                MultiIndexEventTable multiIndex = (MultiIndexEventTable)index;
                EventTable indexToUse = multiIndex.getTables()[indexNumber];
                return innerLookupStrategy.lookup(lookupEvent, indexToUse);
            }
        };
        return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(lookupStrategy, this.masterIndexingStrategy);
    }

    private Class[] getPropertyTypes(EventType eventType, String[] properties) {
        Class[] types = new Class[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = JavaClassHelper.getBoxedType(eventType.getPropertyType(properties[i]));
        }
        return types;
    }
}

