/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.TableLookupStrategy;
import java.util.Arrays;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedTableLookupStrategy
implements TableLookupStrategy {
    private final String[] properties;
    protected final int[] streamNumbers;
    protected final PropertyIndexedEventTable index;
    protected final EventPropertyGetter[] propertyGetters;

    public IndexedTableLookupStrategy(EventType[] eventTypes, int[] streamNumbers, String[] properties, PropertyIndexedEventTable index) {
        this.streamNumbers = streamNumbers;
        this.properties = properties;
        this.index = index;
        this.propertyGetters = new EventPropertyGetter[properties.length];
        for (int i = 0; i < streamNumbers.length; ++i) {
            int streamNumber = streamNumbers[i];
            String property = properties[i];
            EventType eventType = eventTypes[streamNumber];
            this.propertyGetters[i] = eventType.getGetter(property);
            if (this.propertyGetters[i] != null) continue;
            throw new IllegalArgumentException("Property named '" + properties[i] + "' is invalid for type " + eventType);
        }
    }

    public String[] getProperties() {
        return this.properties;
    }

    public PropertyIndexedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean[] eventsPerStream) {
        Object[] keys = this.getKeys(eventsPerStream);
        return this.index.lookup(keys);
    }

    protected Object[] getKeys(EventBean[] eventsPerStream) {
        Object[] keyValues = new Object[this.propertyGetters.length];
        for (int i = 0; i < this.propertyGetters.length; ++i) {
            int streamNum = this.streamNumbers[i];
            EventBean event = eventsPerStream[streamNum];
            keyValues[i] = this.propertyGetters[i].get(event);
        }
        return keyValues;
    }

    public String toString() {
        return "IndexedTableLookupStrategy indexProps=" + Arrays.toString(this.properties) + " index=(" + this.index + ')';
    }
}

