/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.metric;

import com.espertech.esper.epl.metric.MetricExec;
import com.espertech.esper.epl.metric.MetricExecutionContext;
import com.espertech.esper.epl.metric.MetricsExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetricsExecutorThreaded
implements MetricsExecutor {
    private static final Log log = LogFactory.getLog(MetricsExecutorThreaded.class);
    private final ExecutorService threadPool;

    public MetricsExecutorThreaded(final String engineURI) {
        ThreadFactory threadFactory = new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                String uri = engineURI;
                if (engineURI == null) {
                    uri = "default";
                }
                Thread t = new Thread(r);
                t.setName("com.espertech.esper.MetricReporting-" + uri + "-" + this.count.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
        this.threadPool = Executors.newCachedThreadPool(threadFactory);
    }

    public void execute(final MetricExec execution, final MetricExecutionContext executionContext) {
        Runnable runnable = new Runnable(){

            public void run() {
                execution.execute(executionContext);
            }
        };
        this.threadPool.execute(runnable);
    }

    public void destroy() {
        this.threadPool.shutdownNow();
        try {
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Interrupted", e);
        }
    }
}

