/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredEventIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> parent;
    private final List<ExprNode> filterList;
    private final EventBean[] eventPerStream = new EventBean[1];
    private final ExprEvaluatorContext exprEvaluatorContext;
    private EventBean next;

    public FilteredEventIterator(List<ExprNode> filters, Iterator<EventBean> parent, ExprEvaluatorContext exprEvaluatorContext) {
        this.parent = parent;
        this.filterList = filters;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public EventBean next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        EventBean result = this.next;
        this.getNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void getNext() {
        if (this.filterList == null || this.filterList.isEmpty()) {
            this.next = this.parent.hasNext() ? this.parent.next() : null;
            return;
        }
        while (this.parent.hasNext()) {
            this.eventPerStream[0] = this.next = this.parent.next();
            boolean pass = true;
            for (ExprNode filter : this.filterList) {
                Boolean result = (Boolean)filter.evaluate(this.eventPerStream, true, this.exprEvaluatorContext);
                if (result == null || result.booleanValue()) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            return;
        }
        this.next = null;
    }
}

