/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.named.FilteredEventIterator;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.StatementStopService;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowConsumerView
extends ViewSupport
implements StatementStopCallback {
    private static final Log log = LogFactory.getLog(NamedWindowConsumerView.class);
    private final List<ExprNode> filterList;
    private final EventType eventType;
    private final NamedWindowTailView tailView;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private EventBean[] eventPerStream = new EventBean[1];

    public NamedWindowConsumerView(List<ExprNode> filterList, EventType eventType, StatementStopService statementStopService, NamedWindowTailView tailView, ExprEvaluatorContext exprEvaluatorContext) {
        this.filterList = filterList;
        this.eventType = eventType;
        this.tailView = tailView;
        this.exprEvaluatorContext = exprEvaluatorContext;
        statementStopService.addSubscriber(this);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (!this.filterList.isEmpty()) {
            newData = this.passFilter(newData, true, this.exprEvaluatorContext);
            oldData = this.passFilter(oldData, false, this.exprEvaluatorContext);
        }
        if (newData != null || oldData != null) {
            this.updateChildren(newData, oldData);
        }
    }

    private EventBean[] passFilter(EventBean[] eventData, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (eventData == null || eventData.length == 0) {
            return null;
        }
        OneEventCollection filtered = null;
        EventBean[] arr$ = eventData;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean event;
            this.eventPerStream[0] = event = arr$[i$];
            boolean pass = true;
            for (ExprNode filter : this.filterList) {
                Boolean result = (Boolean)filter.evaluate(this.eventPerStream, isNewData, exprEvaluatorContext);
                if (result == null || result.booleanValue()) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            if (filtered == null) {
                filtered = new OneEventCollection();
            }
            filtered.add(event);
        }
        if (filtered == null) {
            return null;
        }
        return filtered.toArray();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new FilteredEventIterator(this.filterList, this.tailView.iterator(), this.exprEvaluatorContext);
    }

    @Override
    public void statementStopped() {
        this.tailView.removeConsumer(this);
    }
}

