/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.named.LookupStrategy;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.StatementStopService;
import com.espertech.esper.view.ViewSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NamedWindowOnExprBaseView
extends ViewSupport
implements StatementStopCallback {
    private static final Log log = LogFactory.getLog(NamedWindowOnExprBaseView.class);
    protected final EventType namedWindowEventType;
    private final LookupStrategy lookupStrategy;
    private final ExprEvaluatorContext exprEvaluatorContext;
    protected final NamedWindowRootView rootView;

    public NamedWindowOnExprBaseView(StatementStopService statementStopService, LookupStrategy lookupStrategy, NamedWindowRootView rootView, ExprEvaluatorContext exprEvaluatorContext) {
        this.lookupStrategy = lookupStrategy;
        this.rootView = rootView;
        statementStopService.addSubscriber(this);
        this.namedWindowEventType = rootView.getEventType();
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    public abstract void handleMatching(EventBean[] var1, EventBean[] var2);

    public void statementStopped() {
        log.debug(".statementStopped");
        this.rootView.removeOnExpr(this.lookupStrategy);
    }

    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (newData == null) {
            return;
        }
        EventBean[] eventsFound = this.lookupStrategy.lookup(newData, this.exprEvaluatorContext);
        this.handleMatching(newData, eventsFound);
    }

    public ExprEvaluatorContext getExprEvaluatorContext() {
        return this.exprEvaluatorContext;
    }
}

