/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.named.LookupStrategy;
import com.espertech.esper.epl.named.NamedWindowOnExprBaseView;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import com.espertech.esper.view.StatementStopService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowOnUpdateView
extends NamedWindowOnExprBaseView {
    private static final Log log = LogFactory.getLog(NamedWindowOnUpdateView.class);
    private EventBean[] lastResult;
    private final StatementResultService statementResultService;
    private final ExprNode[] expressions;
    private final String[] propertyNames;
    private final EventPropertyWriter[] writers;
    private final EventTypeSPI eventTypeSPI;
    private final EventBeanCopyMethod copyMethod;
    private final boolean[] notNullableField;
    private final TypeWidener[] wideners;

    public NamedWindowOnUpdateView(StatementStopService statementStopService, LookupStrategy lookupStrategy, NamedWindowRootView removeStreamView, StatementResultService statementResultService, ExprEvaluatorContext exprEvaluatorContext, OnTriggerWindowUpdateDesc onTriggerDesc) throws ExprValidationException {
        super(statementStopService, lookupStrategy, removeStreamView, exprEvaluatorContext);
        this.statementResultService = statementResultService;
        this.eventTypeSPI = (EventTypeSPI)removeStreamView.getEventType();
        this.wideners = new TypeWidener[onTriggerDesc.getAssignments().size()];
        ArrayList<String> properties = new ArrayList<String>();
        int len = onTriggerDesc.getAssignments().size();
        this.expressions = new ExprNode[len];
        this.writers = new EventPropertyWriter[len];
        this.notNullableField = new boolean[len];
        for (int i = 0; i < onTriggerDesc.getAssignments().size(); ++i) {
            OnTriggerSetAssignment assignment = onTriggerDesc.getAssignments().get(i);
            this.expressions[i] = assignment.getExpression();
            EventPropertyDescriptor writableProperty = this.eventTypeSPI.getWritableProperty(assignment.getVariableName());
            if (writableProperty == null) {
                throw new ExprValidationException("Property '" + assignment.getVariableName() + "' is not available for write access");
            }
            this.writers[i] = this.eventTypeSPI.getWriter(assignment.getVariableName());
            this.notNullableField[i] = writableProperty.getPropertyType().isPrimitive();
            properties.add(assignment.getVariableName());
            this.wideners[i] = TypeWidenerFactory.getCheckPropertyAssignType(assignment.getExpression().toExpressionString(), assignment.getExpression().getType(), writableProperty.getPropertyType(), assignment.getVariableName());
        }
        this.propertyNames = properties.toArray(new String[properties.size()]);
        ArrayList propertiesUniqueList = new ArrayList(new HashSet(properties));
        String[] propertiesArray = propertiesUniqueList.toArray(new String[propertiesUniqueList.size()]);
        this.copyMethod = this.eventTypeSPI.getCopyMethod(propertiesArray);
        if (this.copyMethod == null) {
            throw new ExprValidationException("Event type does not support event bean copy");
        }
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        if (matchingEvents == null || matchingEvents.length == 0) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[2];
        OneEventCollection newData = new OneEventCollection();
        OneEventCollection oldData = new OneEventCollection();
        EventBean[] arr$ = triggerEvents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean triggerEvent;
            eventsPerStream[1] = triggerEvent = arr$[i$];
            for (EventBean matchingEvent : matchingEvents) {
                EventBean copy;
                eventsPerStream[0] = copy = this.copyMethod.copy(matchingEvent);
                for (int i = 0; i < this.expressions.length; ++i) {
                    Object result = this.expressions[i].evaluate(eventsPerStream, true, super.getExprEvaluatorContext());
                    if (result == null && this.notNullableField[i]) {
                        log.warn("Null value returned by expression for assignment to property '" + this.propertyNames[i] + " is ignored as the property type is not nullable for expression '" + this.expressions[i].toExpressionString() + "'");
                        continue;
                    }
                    if (this.wideners[i] != null) {
                        result = this.wideners[i].widen(result);
                    }
                    this.writers[i].write(result, copy);
                }
                newData.add(copy);
                oldData.add(matchingEvent);
            }
        }
        if (!newData.isEmpty()) {
            this.rootView.update(newData.toArray(), oldData.toArray());
            if (this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic()) {
                this.updateChildren(newData.toArray(), oldData.toArray());
            }
        }
        this.lastResult = matchingEvents;
    }

    @Override
    public EventType getEventType() {
        return this.namedWindowEventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new ArrayEventIterator(this.lastResult);
    }
}

