/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.InternalEventRouter;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzer;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.IndexedTableLookupStrategy;
import com.espertech.esper.epl.lookup.IndexedTableLookupStrategyCoercing;
import com.espertech.esper.epl.lookup.JoinedPropDesc;
import com.espertech.esper.epl.named.IndexedPropDesc;
import com.espertech.esper.epl.named.LookupStrategy;
import com.espertech.esper.epl.named.LookupStrategyAllRows;
import com.espertech.esper.epl.named.LookupStrategyIndexed;
import com.espertech.esper.epl.named.LookupStrategyTableScan;
import com.espertech.esper.epl.named.NamedWindowIndexRepository;
import com.espertech.esper.epl.named.NamedWindowOnDeleteView;
import com.espertech.esper.epl.named.NamedWindowOnExprBaseView;
import com.espertech.esper.epl.named.NamedWindowOnSelectView;
import com.espertech.esper.epl.named.NamedWindowOnUpdateView;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerType;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamConstant;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.StatementStopService;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowRootView
extends ViewSupport {
    private static final Log log = LogFactory.getLog(NamedWindowRootView.class);
    private EventType namedWindowEventType;
    private final NamedWindowIndexRepository indexRepository = new NamedWindowIndexRepository();
    private Iterable<EventBean> dataWindowContents;
    private final Map<LookupStrategy, PropertyIndexedEventTable> tablePerStrategy = new HashMap<LookupStrategy, PropertyIndexedEventTable>();
    private final ValueAddEventProcessor revisionProcessor;
    private final ConcurrentHashMap<String, PropertyIndexedEventTable> explicitIndexes = new ConcurrentHashMap();
    private boolean isChildBatching;

    public NamedWindowRootView(ValueAddEventProcessor revisionProcessor) {
        this.revisionProcessor = revisionProcessor;
    }

    public void setDataWindowContents(Iterable<EventBean> dataWindowContents) {
        this.dataWindowContents = dataWindowContents;
    }

    public void removeOldData(EventBean[] oldData) {
        if (this.revisionProcessor != null) {
            this.revisionProcessor.removeOldData(oldData, this.indexRepository);
        } else {
            for (PropertyIndexedEventTable table : this.indexRepository.getTables()) {
                table.remove(oldData);
            }
        }
    }

    public void addNewData(EventBean[] newData) {
        if (this.revisionProcessor == null) {
            for (PropertyIndexedEventTable table : this.indexRepository.getTables()) {
                table.add(newData);
            }
        }
    }

    public synchronized void addExplicitIndex(String namedWindowName, String indexName, List<String> columns) throws ExprValidationException {
        if (this.explicitIndexes.containsKey(indexName)) {
            throw new ExprValidationException("Index by name '" + indexName + "' already exists");
        }
        HashSet<String> indexed = new HashSet<String>();
        IndexedPropDesc[] desc = new IndexedPropDesc[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = columns.get(i);
            Class type = this.namedWindowEventType.getPropertyType(columnName);
            if (type == null) {
                throw new ExprValidationException("Property named '" + columnName + "' not found on named window '" + namedWindowName + "'");
            }
            if (!indexed.add(columnName)) {
                throw new ExprValidationException("Property named '" + columnName + "' has been declared more then once");
            }
            desc[i] = new IndexedPropDesc(columnName, type);
        }
        PropertyIndexedEventTable table = this.indexRepository.addTable(desc, this.dataWindowContents, this.namedWindowEventType, false);
        this.explicitIndexes.put(indexName, table);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (this.revisionProcessor != null) {
            this.revisionProcessor.onUpdate(newData, oldData, this, this.indexRepository);
        } else {
            for (PropertyIndexedEventTable table : this.indexRepository.getTables()) {
                if (this.isChildBatching) {
                    table.add(newData);
                }
                table.remove(oldData);
            }
            this.updateChildren(newData, oldData);
        }
    }

    public NamedWindowOnExprBaseView addOnExpr(OnTriggerDesc onTriggerDesc, ExprNode joinExpr, EventType filterEventType, StatementStopService statementStopService, InternalEventRouter internalEventRouter, ResultSetProcessor resultSetProcessor, EPStatementHandle statementHandle, StatementResultService statementResultService, StatementContext statementContext, boolean isDistinct) throws ExprValidationException {
        Pair<LookupStrategy, PropertyIndexedEventTable> strategy = this.getStrategyPair(onTriggerDesc, joinExpr, filterEventType);
        if (strategy.getSecond() != null) {
            this.tablePerStrategy.put(strategy.getFirst(), strategy.getSecond());
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_DELETE) {
            return new NamedWindowOnDeleteView(statementStopService, strategy.getFirst(), this, statementResultService, statementContext);
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_SELECT) {
            return new NamedWindowOnSelectView(statementStopService, strategy.getFirst(), this, internalEventRouter, resultSetProcessor, statementHandle, statementResultService, statementContext, isDistinct);
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_UPDATE) {
            OnTriggerWindowUpdateDesc desc = (OnTriggerWindowUpdateDesc)onTriggerDesc;
            return new NamedWindowOnUpdateView(statementStopService, strategy.getFirst(), this, statementResultService, statementContext, desc);
        }
        throw new IllegalStateException("Unknown trigger type " + (Object)((Object)onTriggerDesc.getOnTriggerType()));
    }

    public void removeOnExpr(LookupStrategy strategy) {
        PropertyIndexedEventTable table = this.tablePerStrategy.remove(strategy);
        if (table != null) {
            this.indexRepository.removeTableReference(table);
        }
    }

    private Pair<LookupStrategy, PropertyIndexedEventTable> getStrategyPair(OnTriggerDesc onTriggerDesc, ExprNode joinExpr, EventType filterEventType) {
        if (joinExpr == null) {
            return new Pair<LookupStrategyAllRows, Object>(new LookupStrategyAllRows(this.dataWindowContents), null);
        }
        QueryGraph queryGraph = new QueryGraph(2);
        FilterExprAnalyzer.analyze(joinExpr, queryGraph);
        String[] keyPropertiesJoin = queryGraph.getKeyProperties(1, 0);
        String[] indexPropertiesJoin = queryGraph.getIndexProperties(1, 0);
        if (keyPropertiesJoin == null || keyPropertiesJoin.length == 0) {
            return new Pair<LookupStrategyTableScan, Object>(new LookupStrategyTableScan(joinExpr, this.dataWindowContents), null);
        }
        boolean mustCoerce = false;
        Class[] coercionTypes = new Class[indexPropertiesJoin.length];
        for (int i = 0; i < keyPropertiesJoin.length; ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(filterEventType.getPropertyType(keyPropertiesJoin[i]));
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(this.namedWindowEventType.getPropertyType(indexPropertiesJoin[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        Object[] joinedPropDesc = new JoinedPropDesc[keyPropertiesJoin.length];
        Object[] indexedPropDesc = new IndexedPropDesc[keyPropertiesJoin.length];
        for (int i = 0; i < joinedPropDesc.length; ++i) {
            joinedPropDesc[i] = new JoinedPropDesc(indexPropertiesJoin[i], coercionTypes[i], keyPropertiesJoin[i], 1);
            indexedPropDesc[i] = new IndexedPropDesc(indexPropertiesJoin[i], coercionTypes[i]);
        }
        Arrays.sort(joinedPropDesc);
        Arrays.sort(indexedPropDesc);
        keyPropertiesJoin = JoinedPropDesc.getKeyProperties((JoinedPropDesc[])joinedPropDesc);
        PropertyIndexedEventTable table = this.indexRepository.addTable((IndexedPropDesc[])indexedPropDesc, this.dataWindowContents, this.namedWindowEventType, mustCoerce);
        EventType[] eventTypePerStream = new EventType[]{null, filterEventType};
        int[] streamNumbersPerProperty = new int[joinedPropDesc.length];
        for (int i = 0; i < streamNumbersPerProperty.length; ++i) {
            streamNumbersPerProperty[i] = 1;
        }
        IndexedTableLookupStrategy lookupStrategy = null;
        lookupStrategy = !mustCoerce ? new IndexedTableLookupStrategy(eventTypePerStream, streamNumbersPerProperty, keyPropertiesJoin, table) : new IndexedTableLookupStrategyCoercing(eventTypePerStream, streamNumbersPerProperty, keyPropertiesJoin, table, coercionTypes);
        return new Pair<LookupStrategy, PropertyIndexedEventTable>(new LookupStrategyIndexed(joinExpr, lookupStrategy), table);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        this.namedWindowEventType = parent.getEventType();
    }

    @Override
    public EventType getEventType() {
        return this.namedWindowEventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return null;
    }

    public void destroy() {
        this.indexRepository.destroy();
        this.tablePerStrategy.clear();
    }

    public Collection<EventBean> snapshot(FilterSpecCompiled filter) {
        PropertyIndexedEventTable tableFound;
        if (filter.getParameters().isEmpty()) {
            return null;
        }
        HashMap keysAndTypes = new HashMap();
        for (FilterSpecParam param : filter.getParameters()) {
            if (!(param instanceof FilterSpecParamConstant) || param.getFilterOperator() != FilterOperator.EQUAL) continue;
            Object filterValue = param.getFilterValue(null);
            if (filterValue == null) {
                keysAndTypes.put(param.getPropertyName(), null);
                continue;
            }
            keysAndTypes.put(param.getPropertyName(), filterValue.getClass());
        }
        if (keysAndTypes.isEmpty()) {
            return null;
        }
        ArrayList<PropertyIndexedEventTable> candidateTables = null;
        for (PropertyIndexedEventTable table : this.indexRepository.getTables()) {
            boolean missed = false;
            for (String indexedProp : table.getPropertyNames()) {
                if (keysAndTypes.containsKey(indexedProp)) continue;
                missed = true;
                break;
            }
            if (missed) continue;
            if (candidateTables == null) {
                candidateTables = new ArrayList<PropertyIndexedEventTable>();
                candidateTables.add(table);
                continue;
            }
            candidateTables.add(table);
        }
        if (candidateTables == null) {
            if (log.isDebugEnabled()) {
                log.debug("No index found.");
            }
            return null;
        }
        if (candidateTables.size() > 1) {
            Comparator<PropertyIndexedEventTable> comparator = new Comparator<PropertyIndexedEventTable>(){

                @Override
                public int compare(PropertyIndexedEventTable o1, PropertyIndexedEventTable o2) {
                    if (o1.getPropertyNames().length > o2.getPropertyNames().length) {
                        return -1;
                    }
                    if (o1.getPropertyNames().length == o2.getPropertyNames().length) {
                        return 0;
                    }
                    return 1;
                }
            };
            Collections.sort(candidateTables, comparator);
            tableFound = (PropertyIndexedEventTable)candidateTables.get(0);
        } else {
            tableFound = (PropertyIndexedEventTable)candidateTables.get(0);
        }
        if (log.isDebugEnabled()) {
            String indexName = null;
            for (Map.Entry<String, PropertyIndexedEventTable> entry : this.explicitIndexes.entrySet()) {
                if (entry.getValue() != tableFound) continue;
                indexName = entry.getKey();
            }
            log.debug("Using index " + indexName + " for on-demand query");
        }
        Object[] keyValues = new Object[tableFound.getPropertyNames().length];
        block4: for (int keyIndex = 0; keyIndex < tableFound.getPropertyNames().length; ++keyIndex) {
            for (FilterSpecParam param : filter.getParameters()) {
                if (!param.getPropertyName().equals(tableFound.getPropertyNames()[keyIndex])) continue;
                keyValues[keyIndex] = param.getFilterValue(null);
                continue block4;
            }
        }
        Set<EventBean> result = tableFound.lookup(keyValues);
        if (result != null) {
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void removeExplicitIndex(String indexName) {
        EventTable table = this.explicitIndexes.remove(indexName);
        if (table != null) {
            this.indexRepository.removeTableReference(table);
        }
    }

    public void setBatchView(boolean batchView) {
        this.isChildBatching = batchView;
    }
}

