/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.NullIterator;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.view.StatementStopService;
import com.espertech.esper.view.ViewSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowTailView
extends ViewSupport
implements Iterable<EventBean> {
    private static final Iterator<EventBean> nullIterator = new NullIterator<EventBean>();
    private final EventType eventType;
    private final NamedWindowRootView namedWindowRootView;
    private final NamedWindowService namedWindowService;
    private volatile Map<EPStatementHandle, List<NamedWindowConsumerView>> consumers;
    private final EPStatementHandle createWindowStmtHandle;
    private final StatementResultService statementResultService;
    private final ValueAddEventProcessor revisionProcessor;
    private final boolean isPrioritized;
    private volatile long numberOfEvents;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private boolean isParentBatchWindow;

    public NamedWindowTailView(EventType eventType, NamedWindowService namedWindowService, NamedWindowRootView namedWindowRootView, EPStatementHandle createWindowStmtHandle, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, boolean isPrioritized, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventType = eventType;
        this.namedWindowService = namedWindowService;
        this.consumers = this.createConsumerMap();
        this.namedWindowRootView = namedWindowRootView;
        this.createWindowStmtHandle = createWindowStmtHandle;
        this.statementResultService = statementResultService;
        this.revisionProcessor = revisionProcessor;
        this.isPrioritized = isPrioritized;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    public boolean isParentBatchWindow() {
        return this.isParentBatchWindow;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && !this.isParentBatchWindow) {
            this.namedWindowRootView.addNewData(newData);
        }
        if (oldData != null) {
            this.namedWindowRootView.removeOldData(oldData);
            this.numberOfEvents -= (long)oldData.length;
        }
        if (newData != null) {
            this.numberOfEvents += (long)newData.length;
        }
        if (this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic()) {
            this.updateChildren(newData, oldData);
        }
        NamedWindowDeltaData delta = new NamedWindowDeltaData(newData, oldData);
        this.namedWindowService.addDispatch(delta, this.consumers);
    }

    public NamedWindowConsumerView addConsumer(List<ExprNode> filterList, EPStatementHandle statementHandle, StatementStopService statementStopService) {
        NamedWindowConsumerView consumerView = new NamedWindowConsumerView(filterList, this.eventType, statementStopService, this, this.exprEvaluatorContext);
        List<NamedWindowConsumerView> viewsPerStatements = this.consumers.get(statementHandle);
        if (viewsPerStatements == null) {
            viewsPerStatements = new CopyOnWriteArrayList<NamedWindowConsumerView>();
            Map<EPStatementHandle, List<NamedWindowConsumerView>> newConsumers = this.createConsumerMap();
            newConsumers.putAll(this.consumers);
            newConsumers.put(statementHandle, viewsPerStatements);
            this.consumers = newConsumers;
        }
        viewsPerStatements.add(consumerView);
        return consumerView;
    }

    private Map<EPStatementHandle, List<NamedWindowConsumerView>> createConsumerMap() {
        if (!this.isPrioritized) {
            return new LinkedHashMap<EPStatementHandle, List<NamedWindowConsumerView>>();
        }
        return new TreeMap<EPStatementHandle, List<NamedWindowConsumerView>>(new Comparator<EPStatementHandle>(){

            @Override
            public int compare(EPStatementHandle o1, EPStatementHandle o2) {
                if (o1.getPriority() == o2.getPriority()) {
                    return 0;
                }
                return o1.getPriority() > o2.getPriority() ? -1 : 1;
            }
        });
    }

    public void removeConsumer(NamedWindowConsumerView namedWindowConsumerView) {
        EPStatementHandle handleRemoved = null;
        for (Map.Entry<EPStatementHandle, List<NamedWindowConsumerView>> entry : this.consumers.entrySet()) {
            boolean foundAndRemoved = entry.getValue().remove(namedWindowConsumerView);
            if (!foundAndRemoved || entry.getValue().size() != 0) continue;
            handleRemoved = entry.getKey();
            break;
        }
        if (handleRemoved != null) {
            LinkedHashMap<EPStatementHandle, List<NamedWindowConsumerView>> newConsumers = new LinkedHashMap<EPStatementHandle, List<NamedWindowConsumerView>>();
            newConsumers.putAll(this.consumers);
            newConsumers.remove(handleRemoved);
            this.consumers = newConsumers;
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<EventBean> iterator() {
        if (this.revisionProcessor != null) {
            Collection<EventBean> coll = this.revisionProcessor.getSnapshot(this.createWindowStmtHandle, this.parent);
            return coll.iterator();
        }
        this.createWindowStmtHandle.getStatementLock().acquireLock(null);
        try {
            Iterator<EventBean> it = this.parent.iterator();
            if (!it.hasNext()) {
                Iterator<EventBean> iterator = nullIterator;
                return iterator;
            }
            ArrayList<EventBean> list = new ArrayList<EventBean>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayEventIterator arrayEventIterator = new ArrayEventIterator(list.toArray(new EventBean[list.size()]));
            return arrayEventIterator;
        }
        finally {
            this.createWindowStmtHandle.getStatementLock().releaseLock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EventBean> snapshot(FilterSpecCompiled filter) {
        if (this.revisionProcessor != null) {
            return this.revisionProcessor.getSnapshot(this.createWindowStmtHandle, this.parent);
        }
        this.createWindowStmtHandle.getStatementLock().acquireLock(null);
        try {
            Collection<EventBean> indexedResult;
            if (filter != null && (indexedResult = this.namedWindowRootView.snapshot(filter)) != null) {
                Collection<EventBean> collection = indexedResult;
                return collection;
            }
            Iterator<EventBean> it = this.parent.iterator();
            if (!it.hasNext()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayDequeJDK6Backport<EventBean> list = new ArrayDequeJDK6Backport<EventBean>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayDequeJDK6Backport<EventBean> arrayDequeJDK6Backport = list;
            return arrayDequeJDK6Backport;
        }
        finally {
            this.createWindowStmtHandle.getStatementLock().releaseLock(null);
        }
    }

    public void destroy() {
        this.consumers.clear();
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public void setBatchView(boolean batchView) {
        this.isParentBatchWindow = batchView;
    }
}

